<?php

namespace App\Http\Controllers\WEB\Site;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models2\User;
use App\Models2\Address;
use App\Models2\Setting;
use App\Models2\Cart;
use App\Models2\CartAddition;
use App\Models2\OrderAddition;
use App\Models2\ProductOption;
use App\Models2\ProductAddition;
use App\Models2\City;
use App\Models2\NearestCity;
use App\Models2\Token;
use App\Models2\Product;
use App\Models2\Order;
use App\Models2\OrderStore;
use App\Models2\ProductOrder;
use App\Models2\DeliveryCompany;
use App\Models2\DeliveryCost;
use App\Models2\Wallet;
use App\Models2\Notification;
use App\Models2\Quantity;
use App\Models2\Coupon;
use App\Models2\OrderCouponDiscount;	
use Mail;
use Auth;
use Validator;
use Session;
use Illuminate\Validation\Rule;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class CartController extends Controller
{
    public function myCart(Request $request){
        if( $request->session()->get('sessionUser') && $request->session()->get('sessionUser') !== ''){
            $fcm_token = $request->session()->get('sessionUser');
         ////Check product status in terms of availability and update the availability status
         if(auth('web')->check()){
             $cartItems = Cart::where(function($q){
                 $q->where('user_id' , auth('web')->id())->orWhere('fcm_token',session()->get('sessionUser'));
             })->get();
             ////// Start Delete Duplicate Products
            $cartIds = $cartItems->pluck('id')->toArray();
            $duplicate = Cart::where(function($q){
                 $q->where('user_id' , auth('web')->id())
                 ->orWhere('fcm_token',session()->get('sessionUser'));
             })->get()->groupBy(fn($cart) => $cart->product_id)->map(function($data){
                  return collect($data)->sortByDesc('quantity')->unique('option_id');
             })->flatten(1)->pluck('id')->toArray();
             $diffIds = array_diff($cartIds , $duplicate);
             foreach($diffIds as $oneDup){
                Cart::findOrFail($oneDup)->delete();
             }
            //////// End Delete Duplicate Products
         }else{
            $cartItems = Cart::where('fcm_token',$fcm_token)->where('user_id', null)->get();
         }
                if(isset($cartItems)){
                    foreach($cartItems as $i){
                       if ($i->option_id == "") {
                         if ($i->product->limited_quantity == 1 &&  $i->product->available_quantity < $i->quantity) {
                             $i->available = 0 ; 	//0->not available , 1->available
                             $i->save();
                         }elseif($i->product->limited_quantity == 1 &&  $i->product->available_quantity > $i->quantity){
                             $i->available = 1 ; 	
                             $i->save();
                         }
                       }else{
                            if ($i->option->limited_quantity == 1 &&  $i->option->available_quantity < $i->quantity) {
                             $i->available = 0 ; 	//0->not available , 1->available
                             $i->save();
                         }elseif($i->option->limited_quantity == 1 &&  $i->option->available_quantity > $i->quantity){
                             $i->available = 1 ; 	
                             $i->save();
                         }
                       }
                   }

                }
            
        
            ///browsing_type 1 stores , 2 products
             if(auth('web')->check()){
                 $storesIDs = Cart::where(function($q){
                             $q->where('user_id' , auth('web')->id())->orWhere('fcm_token',session()->get('sessionUser'));
                        })->where('browsing_type', 1)->pluck('store_id')->toArray();
                $storesIDs = array_unique($storesIDs);
                $stores = User::whereIn('id',$storesIDs)->get();
                $availableItem = Cart::where(function($q){
                         $q->where('user_id' , auth('web')->id())->orWhere('fcm_token',session()->get('sessionUser'));
                     })->where('browsing_type', 2)->where('available',1)->count();
                $notAvailableItem = Cart::where(function($q){
                         $q->where('user_id' , auth('web')->id())->orWhere('fcm_token',session()->get('sessionUser'));
                     })->where('browsing_type', 2)->where('available',0)->count();
                $sub_total = 0;
             }else{
                $storesIDs = Cart::where('fcm_token',$fcm_token)->where('user_id', null)->where('browsing_type', 1)->pluck('store_id')->toArray();
                $storesIDs = array_unique($storesIDs);
                $stores = User::whereIn('id',$storesIDs)->get();
                $availableItem = Cart::where('user_id' , null)->where('fcm_token',$fcm_token)->where('browsing_type', 2)->where('available',1)->count();
                $notAvailableItem = Cart::where('user_id' , null)->where('fcm_token',$fcm_token)->where('browsing_type', 2)->where('available',0)->count();
                $sub_total = 0;
             }
           
            foreach($stores as $one){
                if(auth('web')->check()){
                $carts = Cart::with('product')->where(function($q) use($fcm_token){
                             $q->where('user_id' , auth('web')->id())->orWhere('fcm_token', $fcm_token);
                        })->where('store_id',$one->id)->where('browsing_type', 1)->get();
                }else{
                    $carts = Cart::with('product')->where('store_id',$one->id)->where('browsing_type', 1)->where('user_id', null)->where('fcm_token',$fcm_token)->get();
                }
                $one['total_products']=$carts->count();
                $store_sub_total=0;
                foreach ($carts as $item) {
                    if($item->option_id == ""){
                    $price =  ($item->product->price_after_offer)? $item->product->price_after_offer:$item->product->price;
                    $store_sub_total +=$price * $item->quantity;
                        if($one->status_now){
                            $sub_total +=$price * $item->quantity;
                        }
                        
                    }elseif($item->option_id != ""){
                    
                    $option=  ProductOption::findOrFail($item->option_id);
                    $price =  ($option->offer_price)? $option->offer_price:$option->price;
                    $store_sub_total +=$price * $item->quantity;
                        if($one->status_now){
                            $sub_total +=$price * $item->quantity;
                        }   
                    }
                }
                $one['store_sub_total']=$store_sub_total;
            }
            return view('web.myCart',['total'=>$sub_total,'stores'=>$stores , 'availableItem'=>$availableItem , 'notAvailableItem'=>$notAvailableItem]);
        }else{
             return view('web.myCart',['total'=> 0,'stores'=> [] , 'availableItem'=> 0 , 'notAvailableItem'=> 0]);
        }
        $message = $request->session()->get('sessionUser');
        return view('web.myCart',['message'=>$message]);
    }
	
	/** test cart **/
	
	 public function testGetCartDetails(Request $request){
        if($request->session()->get('sessionUser') !=='' || auth()->id()){
            $settings = Setting::query()->first();
            $balance = 0;
            $fcm_token = $request->session()->get('sessionUser');
               if(auth()->check()){
                   $user = User::findOrFail(auth()->id());
                   $rialPoint = 0;
                if($user->num_points > 0){
                     $changePointValue = $settings->riyals_for_points;
                    $rialPoint =  $user->num_points / $changePointValue;
                    }   
                    $balance =$user->balance + $rialPoint;

                }
                
                ////Check product status in terms of availability and update the availability status
                if(auth('web')->check()){
                $cartItems = Cart::where(function($q) use($fcm_token){
                   $q->where('fcm_token',$fcm_token)->orWhere('user_id' , auth()->id());
                })->get();
                  
                }else{
                    $cartItems = Cart::where('user_id',null)->where('fcm_token',$fcm_token)->get();
                }
                if(isset($cartItems)){
                     foreach($cartItems as $i){
                       if ($i->option_id == "") {
                         if ($i->product->limited_quantity == 1 &&  $i->product->available_quantity < $i->quantity) {
                             $i->available = 0 ; 	//0->not available , 1->available
                             $i->save();
                         }elseif($i->product->limited_quantity == 1 &&  $i->product->available_quantity > $i->quantity){
                             $i->available = 1 ; 	//0->not available , 1->available
                             $i->save();
                         }
                       }else{
                            if ($i->option->limited_quantity == 1 &&  $i->option->available_quantity < $i->quantity) {
                             $i->available = 0 ; 	//0->not available , 1->available
                             $i->save();
                         }elseif($i->option->limited_quantity == 1 &&  $i->option->available_quantity > $i->quantity){
                             $i->available = 1 ; 	//0->not available , 1->available
                             $i->save();
                         }
                       }
                   }
                }
              /// end check
         
            if($request->type == 1 && $request->store_id != ""){
                  $carts = Cart::where('store_id', $request->store_id)->where('browsing_type', 1)->where(function($q) use($request){
                $q->where('fcm_token', $request->session()->get('sessionUser'))->orWhere('user_id', auth()->id());
            })->with('product','store','option')->get();
             $addresses = null;
             
                if(auth()->check()){
                   // return auth()->id();
                    $addresses = Address::where('user_id',auth()->id())->orderByDesc('id')->get();
                }
                 $store = User::where('id',$request->store_id)->first();
                $cities=City::where('status', 'active')->get();
                 if(auth()->check()){
                  $carts =Cart::where('store_id', $request->store_id)->where('browsing_type', 1)->where(function($q) use($request){
                $q->where('fcm_token', $request->session()->get('sessionUser'))->orWhere('user_id', auth()->id());
            })->with('product','option')->get();
                     
                 }else{
                       $carts =Cart::where('user_id',null)->where('store_id', $request->store_id)->where('browsing_type', 1)->where(function($q) use($request){
                        $q->where('fcm_token', $request->session()->get('sessionUser'));
                    })->with('product','option')->get();
                 }
            
                $sub_total=0;
                foreach ($carts as $item) {
                    if($item->option_id == ""){
                    $price =  ($item->product->price_after_offer)? $item->product->price_after_offer:$item->product->price;
                    $sub_total +=$price * $item->quantity;
                      
                    }elseif($item->option_id != ""){
                     
                     $option=  ProductOption::findOrFail($item->option_id);
                    $price =  ($option->offer_price)? $option->offer_price:$option->price;
                    $sub_total +=$price * $item->quantity;
                         
                    }
                     if($item->additions != ""){
                         foreach ($item->additions as $addition) {
                          $price_addition = ($addition->addition->offer_price) ? $addition->addition->offer_price : $addition->addition->price;
                          if($addition->addition->free == 1){
                               $sub_total += ($addition->quantity - 1) * $price_addition;
                          }else{
                               $sub_total += $addition->quantity * $price_addition;
                          }
                         }
                    }
                }
                  if($request->has('delivery_cost') && $request->delivery_cost != "" ){
                        $vat_percent =  $settings->value_added_tax;
                      $vat = ($sub_total * $vat_percent)/100 ;
                      $delivery = $request->delivery_cost ;
                       $total = $sub_total + $vat + $delivery;
                  }else{
                       $vat_percent =  $settings->value_added_tax;
                      $vat = ($sub_total * $vat_percent)/100 ;
                      $total = $sub_total + $vat;
                      $delivery = 0 ;
                  }
             
            $message = __('website.ok');
          
             return view('web.testCartDetails',['status' => true, 'message' => $message , 'items'=>$carts,'sub_total'=>$sub_total,'vat_percent'=>$vat_percent,'vat'=>$vat 
            ,'delivery_cost'=>$delivery ,'total'=>$total,'store'=>$store,'addresses'=>$addresses,'cities'=>$cities , 'wallet'=>$balance,'settings'=>$settings]);
        
            }elseif($request->type == 2){
                   
             $addresses = null;
                if(auth()->check()){
                   // return auth()->id();
                    $cart = Cart::where('browsing_type', 2)->where('available', 1)->where(function($q) use($request){
                $q->where('fcm_token', $request->session()->get('sessionUser'))->orWhere('user_id', auth()->id());
            })->with('product','option')->get();
                    $addresses = Address::where('user_id',auth()->id())->orderByDesc('id')->get();
                }else{
                     $cart = Cart::where('browsing_type', 2)->where('user_id',null)->where('available', 1)->where('fcm_token', $request->session()->get('sessionUser'))
                     ->with('product','option')->get();
                }
                 $sub_total=0;
                foreach ($cart as $item) {
                    if($item->option_id == ""){
                    $price =  ($item->product->price_after_offer)? $item->product->price_after_offer:$item->product->price;
                    $sub_total +=$price * $item->quantity;
                      
                    }elseif($item->option_id != ""){
                     $option=  ProductOption::findOrFail($item->option_id);
                    $price =  ($option->offer_price)? $option->offer_price:$option->price;
                    $sub_total +=$price * $item->quantity;
                         
                    }
                     if($item->additions != ""){
                         
                         foreach ($item->additions as $addition) {
                          $price_addition = ($addition->addition->offer_price) ? $addition->addition->offer_price : $addition->addition->price;
                          if($price_addition == null){
                              $price_addition = 0;
                          }
                           if($addition->addition->free == 1){
                               $sub_total += ($addition->quantity - 1) * $price_addition;
                          }else{
                               $sub_total += $addition->quantity * $price_addition;
                          }
                         
                         }
                    }
                }
                  if($request->has('delivery_cost') && $request->delivery_cost != "" ){
                        $vat_percent =  $settings->value_added_tax;
                      $vat = ($sub_total * $vat_percent)/100 ;
                      $delivery = $request->delivery_cost ;
                       $total = $sub_total + $vat + $delivery;
                  }else{
                       $vat_percent =  $settings->value_added_tax;
                      $vat = ($sub_total * $vat_percent)/100 ;
                      $delivery = $settings->delivery_charge ;
                      $total = $sub_total + $vat +$delivery;
                  }
                //  $store = User::where('id',$cart[0]->store_id)->first();
                $cities=City::where('status', 'active')->get();
            $message = __('website.ok');
             return view('web.testCartDetails',['status' => true, 'message' => $message , 'items'=>$cart,'addresses'=>$addresses,
            'cities'=>$cities,'sub_total'=>$sub_total,'vat_percent'=>$vat_percent,'vat'=>$vat ,'delivery_cost'=>$delivery ,'total'=>$total, 'wallet'=>$balance]);
        
            // return response()->json(['status' => true, 'message' => $message , 'items'=>$cart,'store'=>$store,'addresses'=>$addresses,
            // 'cities'=>$cities,'sub_total'=>$sub_total,'vat_percent'=>$vat_percent,'vat'=>$vat ,'delivery_cost'=>$delivery ,'total'=>$total, 'wallet'=>$balance]);
        
            }elseif($request->type == 3){
                     $cart = Cart::where('browsing_type', 2)->where('available', 0)->where(function($q) use($request){
                $q->where('fcm_token', $request->session()->get('sessionUser'))->orWhere('user_id', auth()->id());
            })->with('product','store' ,'option')->get();
            
            $message = __('website.ok');
            return view('web.testCartDetails',['status' => true, 'message' => $message , 'items'=>$cart , 'wallet'=>$balance]);
        
            }else{
                 $message = __('api.not_found');
                return view('web.testCartDetails',['status' => false, 'message' => $message ]);
            }
          }
      
        $message = __('api.whoops');
        return response()->json(['status' => false, 'message' => $message ]);
    }
    
	/** end test cart **/
	
	
    public function getCartDetails(Request $request){
        if($request->session()->get('sessionUser') !=='' || auth()->id()){
            $settings = Setting::query()->first();
            $balance = 0;
			$preparing_time = 0;
            $fcm_token = $request->session()->get('sessionUser');
            if(auth()->check()){
                $user = User::findOrFail(auth()->id());
                $rialPoint = 0;
                if($user->num_points > 0){
                    $changePointValue = $settings->riyals_for_points;
                    $rialPoint =  $user->num_points / $changePointValue;
                }   
                $balance =$user->balance + $rialPoint;
            }
                
            ////Check product status in terms of availability and update the availability status
            /*if(auth('web')->check()){
                $cartItems = Cart::where(function($q) use($fcm_token){
                   $q->where('fcm_token',$fcm_token)->orWhere('user_id' , auth()->id());
                })->get();
                  
            }else{
                $cartItems = Cart::where('user_id',null)->where('fcm_token',$fcm_token)->get();
            }
            if(isset($cartItems)){
                 foreach($cartItems as $i){
                     if ($i->option_id == "") {
                         if ($i->product->limited_quantity == 1 &&  $i->product->available_quantity < $i->quantity) {
                             $i->available = 0 ; 	//0->not available , 1->available
                             $i->save();
                         }elseif($i->product->limited_quantity == 1 &&  $i->product->available_quantity > $i->quantity){
                             $i->available = 1 ; 	//0->not available , 1->available
                             $i->save();
                         }
                     }else{
                            if ($i->option->limited_quantity == 1 &&  $i->option->available_quantity < $i->quantity) {
								 $i->available = 0 ; 	//0->not available , 1->available
								 $i->save();
                         	}elseif($i->option->limited_quantity == 1 &&  $i->option->available_quantity > $i->quantity){
								 $i->available = 1 ; 	//0->not available , 1->available
								 $i->save();
                         	}
                     }
                 }
            }*/
            /// end check
         
            if($request->type == 1 && $request->store_id != ""){
                  	//$carts = Cart::where('store_id', $request->store_id)->where(function($q) use($request){
                	//$q->where('fcm_token', $request->session()->get('sessionUser'))->orWhere('user_id', auth()->id());
					//comented})->with('product','store','option')->get();
					//})->get();	
					$addresses = null;
					if(auth()->check()){
						// return auth()->id();
						$addresses = Address::where('user_id',auth()->id())->orderByDesc('id')->get();
					}
					//$store = User::select('id')->where('id',$request->store_id)->first();
				    $store = User::where('id',$request->store_id)->first();
					$cities=City::select('id')->where('status', 'active')->get();
					if(auth()->check()){
							$carts =Cart::where('store_id', $request->store_id)->where(function($q) use($request){
							$q->where('fcm_token', $request->session()->get('sessionUser'))->orWhere('user_id', auth()->id());
							//})->with('product','option')->get();
							})->get();
					}else{ 
							$carts =Cart::where('user_id',null)->where('store_id', $request->store_id)->where(function($q) use($request){
							$q->where('fcm_token', $request->session()->get('sessionUser'));
							//})->with('product','option')->get();
							})->get();	
					}
					//return $carts;
					$sub_total=0;
					foreach ($carts as $item) {
						if($preparing_time <  (int)$item->product->preparing_time){
							$preparing_time = (int)$item->product->preparing_time;
							//$preparing_time += $item->product->preparing_time;
						}
						if($item->option_id == ""){
							$price =  ($item->product->price_after_offer)? $item->product->price_after_offer:$item->product->price;
							$sub_total +=$price * $item->quantity;
						}elseif($item->option_id != ""){
							$option=  ProductOption::findOrFail($item->option_id);
							$price =  ($option->offer_price)? $option->offer_price:$option->price;
							$sub_total +=$price * $item->quantity;
						}

						if(!empty($item->additions)){
							 foreach ($item->additions as $addition) {
								  $price_addition = ($addition->addition->offer_price) ? $addition->addition->offer_price : $addition->addition->price;
								  if($addition->addition->free == 1){
									   $sub_total += ($addition->quantity - 1) * $price_addition;
								  }else{
									   $sub_total += $addition->quantity * $price_addition;
								  }
							 }
						}
					}
					if($request->has('delivery_cost') && $request->delivery_cost != "" ){
						   $vat_percent =  $settings->value_added_tax;
						   $vat = ($sub_total * $vat_percent)/100 ;
						   $delivery = $request->delivery_cost ;
						   $total = $sub_total + $vat + $delivery;
					}else{
						   $vat_percent =  $settings->value_added_tax;
						   $vat = ($sub_total * $vat_percent)/100 ;
						   $total = $sub_total + $vat;
						   $delivery = 0 ;
					}

				
					$preparing_time = Carbon::now()->addMinutes($preparing_time)->diffForHumans(null, ['parts' => 2, 'options' => Carbon::ROUND]);
					$preparing_time = str_replace(" from now", "", $preparing_time);
					$preparing_time = str_replace(" seconds ago", "", $preparing_time);
					$preparing_time = $preparing_time == 0 ? "Ready Now" : $preparing_time;
					$message = __('website.ok');
					return view('web.cartDetails',['status' => true, 'message' => $message ,
												   'items'=>$carts,'sub_total'=>$sub_total,'vat_percent'=>$vat_percent,'vat'=>$vat 
							,'delivery_cost'=>$delivery ,'total'=>$total,'store'=>$store,'addresses'=>$addresses,'cities'=>$cities ,
												   'wallet'=>$balance,'settings'=>$settings, 'preparing_time' => $preparing_time]);
        
            }elseif($request->type == 2){
                   
             	$addresses = null;
                if(auth()->check()){
                   	// return auth()->id();
                    $cart = Cart::where('browsing_type', 2)->where('available', 1)->where(function($q) use($request){
                	$q->where('fcm_token', $request->session()->get('sessionUser'))->orWhere('user_id', auth()->id());
            		})->with('product','option')->get();
                    $addresses = Address::where('user_id',auth()->id())->orderByDesc('id')->get();
                }else{
                     $cart = Cart::where('browsing_type', 2)->where('user_id',null)->where('available', 1)->where('fcm_token', 
																$request->session()->get('sessionUser'))->with('product','option')->get();
                }
                $sub_total=0;
                foreach ($cart as $item) {
                    if($item->option_id == ""){
						$price =  ($item->product->price_after_offer)? $item->product->price_after_offer:$item->product->price;
						$sub_total +=$price * $item->quantity;
                    }elseif($item->option_id != ""){
                     	$option=  ProductOption::findOrFail($item->option_id);
                    	$price =  ($option->offer_price)? $option->offer_price:$option->price;
                    	$sub_total +=$price * $item->quantity;   
                    }
                    if($item->additions != ""){
                         foreach ($item->additions as $addition) {
                          	$price_addition = ($addition->addition->offer_price) ? $addition->addition->offer_price : $addition->addition->price;
                          	if($price_addition == null){
                                $price_addition = 0;
                          	}
                            if($addition->addition->free == 1){
                                $sub_total += ($addition->quantity - 1) * $price_addition;
                            }else{
                                $sub_total += $addition->quantity * $price_addition;
                            }
                         }
                    }
                }
                if($request->has('delivery_cost') && $request->delivery_cost != "" ){
                      $vat_percent =  $settings->value_added_tax;
                      $vat = ($sub_total * $vat_percent)/100 ;
                      $delivery = $request->delivery_cost ;
                      $total = $sub_total + $vat + $delivery;
                }else{
                      $vat_percent =  $settings->value_added_tax;
                      $vat = ($sub_total * $vat_percent)/100 ;
                      $delivery = $settings->delivery_charge ;
                      $total = $sub_total + $vat +$delivery;
                }
                //  $store = User::where('id',$cart[0]->store_id)->first();
                $cities=City::where('status', 'active')->get();
            	$message = __('website.ok');
             	return view('web.cartDetails',['status' => true, 'message' => $message , 'items'=>$cart,'addresses'=>$addresses,
                'cities'=>$cities,'sub_total'=>$sub_total,'vat_percent'=>$vat_percent,'vat'=>$vat ,'delivery_cost'=>$delivery ,'total'=>$total, 
											   'wallet'=>$balance]);
        
            // return response()->json(['status' => true, 'message' => $message , 'items'=>$cart,'store'=>$store,'addresses'=>$addresses,
            // 'cities'=>$cities,'sub_total'=>$sub_total,'vat_percent'=>$vat_percent,'vat'=>$vat ,'delivery_cost'=>$delivery ,'total'=>$total, 'wallet'=>$balance]);
        
            }elseif($request->type == 3){
                 $cart = Cart::where('browsing_type', 2)->where('available', 0)->where(function($q) use($request){
                 $q->where('fcm_token', $request->session()->get('sessionUser'))->orWhere('user_id', auth()->id());
            	 })->with('product','store' ,'option')->get();
            
         		 $message = __('website.ok');
            	 return view('web.cartDetails',['status' => true, 'message' => $message , 'items'=>$cart , 'wallet'=>$balance]);
        
            }else{
				return 'sb';
                 $message = __('api.not_found');
                 return view('web.cartDetails',['status' => false, 'message' => $message ]);
            }
        }
        $message = __('api.whoops');
        return response()->json(['status' => false, 'message' => $message ]);
    }

    public function addProductToCart(Request $request){
        if (!$request->session()->has('browseType') || $request->session()->get('browseType') === '') {
            Session::put('browseType', '1'); 
            $browseType = 1;
        }else{
            $browseType = Session::get('browseType');
        }
        
        if (!$request->session()->has('sessionUser') || $request->session()->get('sessionUser') === '') {
            $session_id = str_random(15) . "_" . rand(1000000, 9999999) . "_" . time() . "_" . rand(1000000, 9999999);
            $request->session()->put('sessionUser',$session_id);
        }
        $validator = Validator::make($request->all(), [
            'product_id' => 'required',
            'option_id' => 'required',
            'quantity' => 'required|gt:0',
        ]);
    
        if ($validator->fails()) {
            return response()->json(['status' => false,'message' => implode("\n", $validator->messages()->all())]);
        }
        if($request->has('browsing_type') && $request->browsing_type!=0){
            $browseType=$request->browsing_type;
        }
        $product = Product::findOrFail($request->product_id);
        if ($product->delete == 1) {
            $message = __('api.product_deleted');
            return response()->json(['status' => false, 'message' => $message]);
        }
		if ($product->show_product == 0) {
				$message = __('website.ItemsInStock');
				return response()->json(['status' => false, 'message' => $message]);
			}
        if (auth()->check() && auth()->id() == $product->user_id) {
            $message = __('api.cant_add_your_product_to_your_cart');
            return response()->json(['status' => false, 'message' => $message]);
        } else {
            if ($request->option_id == "0") {
                
                 if ($product->limited_quantity == 1 && $product->available_quantity < (int)$request->quantity){
                     $message = __('website.ItemsInStock').' '.$product->name .' ( '.$product->available_quantity.' ) ';
                    return response()->json(['status' => false, 'message' => $message]);
                }
                // if ($product->limited_quantity == 1 && $product->available_quantity = 0) {
                     if ($product->limited_quantity == 1 && $product->available_quantity > (int)$request->quantity) {
                    $check = Cart::where('fcm_token', $request->session()->get('sessionUser'))->where('user_id' , null)->where('product_id', $request->product_id)->where('browsing_type', $browseType)->first();
                    if (auth()->check()) {
                        $check = Cart::where('user_id', auth()->user()->id)->where('product_id', $request->product_id)->where('browsing_type', $browseType)->first();
                    }
                    if ($check) {
                        $message = __('api.alreadyInCart');
                      return response()->json(['status' => false, 'message' => $message]);
                    }
                    $cart = new Cart();
                    if (auth()->check()) {
                        $cart->user_id = auth()->user()->id;
                         $cart->fcm_token = null;
                    }else{
                       $cart->fcm_token = $request->session()->get('sessionUser');
                    }
                    $cart->store_id = $product->user_id;
                    $cart->product_id = $request->product_id;
                    $cart->quantity = $request->quantity;
                    $cart->browsing_type = $browseType;
                    $cart->lang = getLocal();
                    $cart->available = 0;
                    $cart->save();
                    if ($request->has('additions') && $request->additions != 0 && $request->has('quantity_addition') && $request->quantity_addition != 0) {
                        $index = 0;
                        foreach ($request->additions as $addition) {
                            $newAddition = new CartAddition();
                            $newAddition->cart_id = $cart->id;
                            $newAddition->product_id = $cart->product_id;
                            $newAddition->addition_id = $addition;
                            $newAddition->quantity = $request->quantity_addition[$index];
                            $newAddition->save();
                            $index++;
                        }
    
                    }
                    if(auth('web')->check()){
                        $total_in_cart = Cart::where(function($q){$q->where('user_id' , auth('web')->id())->where('fcm_token',session()->get('sessionUser'));})->count();
                    }else{
                        $total_in_cart = Cart::where('user_id' , null)->where('fcm_token', $request->session()->get('sessionUser'))->count();
                    }
                    $message = __('website.ok');
                    return response()->json(['status' => true, 'message' => $message,'total_in_cart'=>$total_in_cart]);
                    
                   
                } else {///browsing_type 1 stores , 2 products
                    $check = Cart::where('fcm_token', $request->session()->get('sessionUser'))->where('user_id' , null)->where('product_id', $request->product_id)->where('browsing_type', $browseType)->first();
                    if (auth()->check()) {
                        $check = Cart::where('user_id', auth()->user()->id)->where('product_id', $request->product_id)->where('browsing_type', $browseType)->first();
                    }
    
                    if ($check) {
                        $message = __('api.alreadyInCart');
                      return response()->json(['status' => false, 'message' => $message]);
                    }
    
                    $cart = new Cart();
                    if (auth()->check()) {
                        $cart->user_id = auth()->user()->id;
                    }
                    $cart->fcm_token = $request->session()->get('sessionUser');
                    $cart->store_id = $product->user_id;
                    $cart->product_id = $request->product_id;
                    $cart->quantity = $request->quantity;
                    $cart->browsing_type = $browseType;
                     $cart->lang = getLocal();
                    $cart->available = 1;
                    $cart->save();
                    if ($request->has('additions') && $request->additions != 0 && $request->has('quantity_addition') && $request->quantity_addition != 0) {
                        $index = 0;
                        foreach ($request->additions as $addition) {
                            $newAddition = new CartAddition();
                            $newAddition->cart_id = $cart->id;
                            $newAddition->product_id = $cart->product_id;
                            $newAddition->addition_id = $addition;
                            $newAddition->quantity = $request->quantity_addition[$index];
                            $newAddition->save();
                            $index++;
                        }
    
                    }
                    
                    if(auth('web')->check()){
                        $total_in_cart = Cart::where(function($q){$q->where('user_id' , auth('web')->id())->where('fcm_token',session()->get('sessionUser'));})->count();
                    }else{
                        $total_in_cart = Cart::where('user_id' , null)->where('fcm_token', $request->session()->get('sessionUser'))->count();
                    }
                    $message = __('website.ok');
                    return response()->json(['status' => true, 'message' => $message,'total_in_cart'=>$total_in_cart]);
                    
                   
                }
            } elseif ($request->option_id != "") {
                $option = ProductOption::findOrFail($request->option_id);
                if($option->product_id != $product->id){
                    $message = __('api.whoops');
                    return response()->json(['status' => false, 'message' => $message]);
                }
                if ($option->limited_quantity == 1 && $option->available_quantity < (int)$request->quantity){
                     $message = __('website.ItemsInStock').' '.$option->name .' ( '.$option->available_quantity.' ) ';
                    return response()->json(['status' => false, 'message' => $message]);
                }
                if ($option->limited_quantity == 1 && $option->available_quantity > (int)$request->quantity) {///browsing_type 1 stores , 2 products
                    $check = Cart::where('fcm_token', $request->session()->get('sessionUser'))->where('product_id', $request->product_id)->where('browsing_type', $browseType)->where('option_id', $request->option_id)->first();
                    if (auth()->check()) {
                        $check = Cart::where('user_id', auth()->user()->id)->where('product_id', $request->product_id)->where('browsing_type', $browseType)->where('option_id', $request->option_id)->first();
                    }
                    if ($check) {
                        $message = __('api.alreadyInCart');
                        return response()->json(['status' => false, 'message' => $message]);
                    }
                    $cart = new Cart();
                    if (auth()->check()) {
                        $cart->user_id = auth()->user()->id;
                    }
                    $cart->fcm_token = $request->session()->get('sessionUser');
                    $cart->store_id = $product->user_id;
                    $cart->product_id = $request->product_id;
                    $cart->quantity = $request->quantity;
                    $cart->browsing_type = $browseType;
                    $cart->option_id = $request->option_id;
                    $cart->lang = getLocal();
                    $cart->available = 0;
                    $cart->save();
                    if ($request->has('additions') && $request->additions != 0 && $request->has('quantity_addition') && $request->quantity_addition != 0) {
                        $index = 0;
                        foreach ($request->additions as $addition) {
                            $newAddition = new CartAddition();
                            $newAddition->cart_id = $cart->id;
                            $newAddition->product_id = $cart->product_id;
                            $newAddition->addition_id = $addition;
                            $newAddition->quantity = $request->quantity_addition[$index];
                            $newAddition->save();
                            $index++;
                        }
    
                    }
                  
                     if(auth('web')->check()){
                        $total_in_cart = Cart::where(function($q){$q->where('user_id' , auth('web')->id())->where('fcm_token',session()->get('sessionUser'));})->count();
                    }else{
                        $total_in_cart = Cart::where('user_id' , null)->where('fcm_token', $request->session()->get('sessionUser'))->count();
                    }
                    $message = __('website.ok');
                    return response()->json(['status' => true, 'message' => $message,'total_in_cart'=>$total_in_cart]);
                    
                } else {
                    $check = Cart::where('fcm_token', $request->session()->get('sessionUser'))->where('product_id', $request->product_id)->where('browsing_type', $browseType)->where('option_id', $request->option_id)->first();
                    if (auth()->check()) {
                        $check = Cart::where('user_id', auth()->user()->id)->where('product_id', $request->product_id)->where('browsing_type', $browseType)->where('option_id', $request->option_id)->first();
                    }
                    if ($check) {
                        $message = __('api.alreadyInCart');
                        return response()->json(['status' => false, 'message' => $message]);
                    }
                    $cart = new Cart();
                    if (auth()->check()) {
                        $cart->user_id = auth()->user()->id;
                    }
                    $cart->fcm_token = $request->session()->get('sessionUser');
                    $cart->store_id = $product->user_id;
                    $cart->product_id = $request->product_id;
                    $cart->quantity = $request->quantity;
                    $cart->browsing_type = $browseType;
                    $cart->option_id = $request->option_id;
                    $cart->lang = getLocal();
                    $cart->available = 1;
                    $cart->save();
                    if ($request->has('additions') && $request->has('quantity_addition') ) {
                        $index = 0;
                        foreach ($request->additions as $addition) {
                            $newAddition = new CartAddition();
                            $newAddition->cart_id = $cart->id;
                            $newAddition->product_id = $cart->product_id;
                            $newAddition->addition_id = $addition;
                            $newAddition->quantity = $request->quantity_addition[$index];
                            $newAddition->save();
                            $index++;
                        }
    
                    }
                     if(auth('web')->check()){
                        $total_in_cart = Cart::where(function($q){$q->where('user_id' , auth('web')->id())->where('fcm_token',session()->get('sessionUser'));})->count();
                    }else{
                        $total_in_cart = Cart::where('user_id' , null)->where('fcm_token', $request->session()->get('sessionUser'))->count();
                    }
                    $message = __('website.ok');
                    return response()->json(['status' => true, 'message' => $message,'total_in_cart'=>$total_in_cart]);
                }
    
            }
        }

    }

    public function removeFromCart(Request $request,$cart_id){
        if($request->session()->get('sessionUser') !==''){
			$preparing_time = 0;
            $cart = Cart::where('id',$cart_id)->where(function($q) use($request){
                $q->where('fcm_token', $request->session()->get('sessionUser'))->orWhere('user_id', auth()->id());
            })->first();
            if ($cart) {
                $cart->delete();
				$carts = Cart::where('user_id', auth()->id())->where('fcm_token', $request->session()->get('sessionUser'))->get();
                if(auth('web')->check()){
						$carts = Cart::where(function($q){$q->where('user_id' , auth('web')->id())->OrWhere('fcm_token',session()->get('sessionUser'));})->get();
                    }else{
                        $carts = Cart::where('user_id' , null)->where('fcm_token', $request->session()->get('sessionUser'))->get();
                    }
				$total_in_cart = $carts->count();
				if (count($carts)){
					foreach ($carts as $item) {
						if($preparing_time <  (int)$item->product->preparing_time){
							$preparing_time = (int)$item->product->preparing_time;
						}
					}
				}
				
				 $preparing_time = Carbon::now()->addMinutes($preparing_time)->diffForHumans(null, ['parts' => 2, 'options' => Carbon::ROUND]);
			 	 $preparing_time = str_replace(" from now", "", $preparing_time);
			 	 $preparing_time = str_replace(" seconds ago", "", $preparing_time);
			 	 $preparing_time = $preparing_time == 0 ? "Ready Now" : $preparing_time;
                $message = __('website.ok');
                return response()->json(['status' => true, 'message' => $message,'total_in_cart'=>$total_in_cart, 'preparing_time' => $preparing_time]);
            }
            return ['status'=>true];
        }
        return ['status'=>true];

    }
    
    public function removeProductFromCart(Request $request){
        if($request->session()->get('sessionUser') !==''){
            $cart = Cart::where('product_id',$request->product_id)->where('browsing_type',$request->session()->get('browseType'))->where(function($q) use($request){
                $q->where('fcm_token', $request->session()->get('sessionUser'))->orWhere('user_id', auth()->id());
            })->first();
            if ($cart) {
                $cart->delete();
                if(auth('web')->check()){
                        $total_in_cart = Cart::where(function($q){$q->where('user_id' , auth('web')->id())->where('fcm_token',session()->get('sessionUser'));})->count();
                    }else{
                        $total_in_cart = Cart::where('user_id' , null)->where('fcm_token', $request->session()->get('sessionUser'))->count();
                    }
                $message = __('website.ok');
                return response()->json(['status' => true, 'message' => $message,'total_in_cart'=>$total_in_cart]);
            }
            $message = __('website.whoops');
            return ['status'=>false, 'message' => $message];
        }
         $message = __('website.whoops');
        return ['status'=>false, 'message' => $message];

    }
    
    public function getDeliveryCompaniesInCart(Request $request){
            $validator = Validator::make($request->all(), [
                'address_id' => 'required_without:city_id',
                'city_id' => 'required_without:address_id',
                'store_id' => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json(['status' => false,'message' => implode("\n", $validator->messages()->all())]);
            }
            
            $store = User::findOrFail($request->store_id);
            if ($store->show_delivery_company == 1) {
                if ($request->has('address_id') && $request->address_id != '' && $request->address_id > 0) {
                    $address = Address::findOrFail($request->address_id);
                    $cityTo = $address->city_id;
                }
                else {
                    $cityTo = $request->city_id;
                }
                if(auth()->check()){
                    $carts =Cart::where('store_id', $request->store_id)->where('browsing_type', 1)->where(function($q) use($request){
                        $q->where('fcm_token', $request->header('fcm_token'))->orWhere('user_id', auth()->id());
                    })->with('product')->get();
                }
                else{
                    $carts =Cart::where('store_id', $request->store_id)->where('browsing_type', 1)->where('fcm_token', $request->header('fcm_token'))->with('product')->get();
                }
                $total=0;
                $preparing_time = 0 ;
                foreach ($carts as $item){
                  if($preparing_time <  (int)$item->product->preparing_time){
                    	$preparing_time = (int)$item->product->preparing_time;
                	}
                    if($item->option_id == ""){
                        $price =  ($item->product->price_after_offer)? $item->product->price_after_offer:$item->product->price;
                        $total +=$price * $item->quantity;
                    }
                    elseif($item->option_id != ""){
                        $option=  ProductOption::findOrFail($item->option_id);
                        $price =  ($option->offer_price)? $option->offer_price:$option->price;
                        $total +=$price * $item->quantity;
                    }
                }
                $delivery_companies = DeliveryCompany::where('status', 'active')->orderBy('order', 'asc')->get();
                $list = array();
                $deliveryCost = 0;
                $min_order = 0;
                $duration = 0;
                $estimated_arrival_time = '';
                if (!empty($delivery_companies)){
                    if ($store->is_delivery == 1){
                        if ($delivery_companies[0]->id == 1){
                            $deliveryCost = 0;
                            if ($delivery_companies[0]->delivery_cost_type == 1){
                                if ($store->city_id == $cityTo  && $delivery_companies[0]->same_delivery_cost > -1) {
                                    $deliveryCost = $delivery_companies[0]->same_delivery_cost;
                                    $min_order = $delivery_companies[0]->same_min_order;
                                    $duration = $delivery_companies[0]->same_duration;
                                }
                                else{
                                 $check = NearestCity::where(function($q) use($cityTo, $store){
                                           $q->where('main_city' , $store->city_id)->where('city_id', $cityTo)->orWhere('main_city' , $cityTo)->where( 'city_id' , $store->city_id);
                                       })->first();                                    
                               if ($check && $delivery_companies[0]->near_delivery_cost > -1) {
                                        $deliveryCost = $delivery_companies[0]->near_delivery_cost;
                                        $min_order = $delivery_companies[0]->near_min_order;
                                        $duration = $delivery_companies[0]->near_duration;
                                    } elseif($delivery_companies[0]->far_delivery_cost > -1) {
                                        $deliveryCost = $delivery_companies[0]->far_delivery_cost;
                                        $min_order = $delivery_companies[0]->far_min_order;
                                        $duration = $delivery_companies[0]->far_duration;
                                    }
                                }
                            }
                            else{
                                $delivery = DeliveryCost::where('delivery_company_id', $delivery_companies[0]->id)
                                    ->where(function ($q) use ($store, $cityTo) {
                                        $q->where('cityfrom' , $store->city_id)->where('cityto' , $cityTo)
                                            ->orWhere('cityfrom' , $cityTo)->where('cityto' , $store->city_id);
                                    })->first();
                                $deliveryCost = $delivery->cost;
                                $min_order = $delivery->min_cost;
                                $duration = $delivery->duration;
                            }
                            if ($deliveryCost > -1) {
                                $name = $delivery_companies[0]->name;
                                 (int)$preparing_time_new = 40 + $preparing_time + $duration;
                                 $estimated_arrival_time = Carbon::now()->addMinutes($preparing_time_new);
                                $list[] = ['id' => $delivery_companies[0]->id, 'name' => $name, 'cost' => $deliveryCost, 'min_order' => $min_order, 'duration' => $duration,'estimated_arrival_time'=> $estimated_arrival_time];
                            }
                        }
                    }
                    if ($store->has_team == 1) {
                        $deliveryCost = 0;
                        if ($store->delivery_cost_type == 1 ) {
                            if ($store->city_id == $cityTo && $store->same_delivery_cost > -1) {
                                $deliveryCost = $store->same_delivery_cost;
                                $min_order = $store->same_min_order;
                                $duration = $store->duration_same;
                            } else {
                                 $check = NearestCity::where(function($q) use($cityTo, $store){
                                           $q->where('main_city' , $store->city_id)->where('city_id', $cityTo)->orWhere('main_city' , $cityTo)->where( 'city_id' , $store->city_id);
                                       })->first();                                
                                   if ($check && $store->near_delivery_cost > -1) {
                                    $deliveryCost = $store->near_delivery_cost;
                                    $min_order = $store->near_min_order;
                                    $duration = $store->duration_near;
                                } elseif($store->far_delivery_cost > -1) {
                                    $deliveryCost = $store->far_delivery_cost;
                                    $min_order = $store->far_min_order;
                                    $duration = $store->duration_far;
                                }
                            }
                        } else {
                            $delivery = DeliveryCost::where('store_id', $store->id)
                                ->where(function ($q) use ($store, $cityTo) {
                                    $q->where('cityfrom' , $store->city_id)->where('cityto' , $cityTo)
                                        ->orWhere('cityfrom' , $cityTo)->where('cityto' , $store->city_id);
                                })->first();
                            $deliveryCost = $delivery->cost;
                            $min_order = $delivery->min_cost;
                            $duration = $delivery->duration;
                        }
                        if ($deliveryCost > -1 && $total >= $min_order) {
                            $name = $store->name;
                             (int)$preparing_time_new = 40 + $preparing_time + $duration;
                              $estimated_arrival_time = Carbon::now()->addMinutes($preparing_time_new);
                            $list[] = ['id' => 0, 'name' => $name, 'cost' => $deliveryCost, 'min_order' => $min_order, 'duration' => $duration , 'estimated_arrival_time'=>$estimated_arrival_time];
                        }

                    }
                    foreach ($delivery_companies as $comp) {
                        $deliveryCost = 0;
                        if ($comp->delivery_cost_type == 1) {
                            if ($store->city_id == $cityTo) {
                                $deliveryCost = $comp->same_delivery_cost;
                                $min_order = $comp->same_min_order;
                                $duration = $comp->same_duration;
                            } else {
                         $check = NearestCity::where(function($q) use($cityTo, $store){
                               $q->where('main_city' , $store->city_id)->where('city_id', $cityTo)->orWhere('main_city' , $cityTo)->where( 'city_id' , $store->city_id);
                           })->first();                                
                           if ($check) {
                                    $deliveryCost = $comp->near_delivery_cost;
                                    $min_order = $comp->near_min_order;
                                    $duration = $comp->near_duration;
                                } else {
                                    $deliveryCost = $comp->far_delivery_cost;
                                    $min_order = $comp->far_min_order;
                                    $duration = $comp->far_duration;
                                }
                            }
                        } else {
                            $delivery = DeliveryCost::where('delivery_company_id', $comp->id)
                                ->where(function ($q) use ($store, $cityTo) {
                                    $q->where('cityfrom' , $store->city_id)->where('cityto' , $cityTo)
                                        ->orWhere('cityfrom' , $cityTo)->where( 'cityto' , $store->city_id);
                                })->first();
                                // return [ $store->city_id , $cityTo , $delivery];
                            $deliveryCost = $delivery->cost;
                            $min_order = $delivery->min_cost;
                            $duration = $delivery->duration;
                        }
                        if ($deliveryCost > -1 && $total >= $min_order) {
                            $name = $comp->name;
                             (int)$preparing_time_new = 40 + $preparing_time + $duration;
                               $estimated_arrival_time = Carbon::now()->addMinutes($preparing_time_new);
                            $list[] = ['id' => $comp->id, 'name' => $name, 'cost' => $deliveryCost, 'min_order' => $min_order, 'duration' => $duration , 'estimated_arrival_time'=>$estimated_arrival_time];
                        }

                    }
                }
                if (!empty($list)) {
                       
                    $message = __('website.ok');
                    return response()->json(['status' => true,  'message' => $message, 'delivery_companies' => $list]);
                }
                $message = __('api.sorryNoDeliveryForThisStore');
                return response()->json(['status' => false, 'message' => $message]);
            }
            else {
                $settings = Setting::query()->first();
                $deliveryCost = $settings->delivery_charge;
                if ($deliveryCost > -1) {
                    $list[] = ['id' => -2, 'name' => __("api.FixedDeliveryFee"), 'cost' => $deliveryCost];
                }
                $message = __('website.ok');
                return response()->json(['status' => true, 'message' => $message, 'delivery_companies' => $list]);
            }
    }

    public function removeStoreFromCart(Request $request,$store_id){
        if($request->session()->get('sessionUser') !==''){
            $carts=Cart::where(['fcm_token'=>$request->session()->get('sessionUser'),'store_id'=>$store_id])->delete();
            $sub_total = 0;
            $carts = Cart::with('product')->where('fcm_token',$request->session()->get('sessionUser'))->get();
            foreach ($carts as $one) {
                $price =  ($one->product->price_after_offer)? $one->product->price_after_offer:$one->product->price;
                $sub_total +=$price * $one->quantity;
            }
            return ['status'=>'done','sub_total'=>$sub_total];
        }
        return 0;

    }
   
    public function changeQuantity(Request $request){
     
        if($request->session()->get('sessionUser') !==''){
            $rules = [
                'cart_id' => 'required',
                'type' => 'required|in:decrease,increase',
    
            ];
            $this->validate($request, $rules);
            if(auth()->check()){
                $cart = Cart::where('id', $request->cart_id)->where(function($q) use($request){
                       $q->where('fcm_token',$request->session()->get('sessionUser'))->orWhere('user_id' ,auth()->id());
                })->first();
            }else{
                  $cart = Cart::where('id', $request->cart_id)->where('fcm_token',$request->session()->get('sessionUser'))->first();
            }
            if (isset($cart)) { 
           
                $product = Product::findOrFail($cart->product_id);
                if($cart->option_id == ""){ 
                    $quantity_product = Product::findOrFail($cart->product_id);
                    if ($request->type == 'increase') {
                        if($product->limited_quantity ==1 && $quantity_product->available_quantity < $cart->quantity + 1){
                            $message = __('api.no_quantity_available');
                            return response()->json(['status' => false, 'code' => 201, 'message' => $message , 'quantity'=> $quantity_product->available_quantity]);
                        }
                        $newValue = $cart->quantity + 1;
                        $cart->update(['quantity'=>$newValue]);
                        $message = __('website.ok');
                         return response()->json(['status' => true, 'code' => 200, 'message' => $message ,'items'=>$cart]);
                    } 
                    else if ($request->type == 'decrease' && $cart->quantity > 1) {
                        $newValue = $cart->quantity - 1;
                        if($cart->browsing_type == 2 && $cart->available == 0 && $newValue <= $quantity_product->available_quantity){
                            $cart->update(['quantity'=>$newValue, 'available' => 1]);
                            $message = __('api.product_in_available_item');
                            return response()->json(['status' => true, 'code' => 208, 'message' => $message ,'items'=>$cart]);
                        }
                        $cart->update(['quantity'=>$newValue]);
                        $message = __('website.ok');
                        return response()->json(['status' => true, 'code' => 200, 'message' => $message ,'items'=>$cart]);
                    }
                    else {
                        $message = __('api.cant_be_zero');
                    return response()->json(['status' => false, 'code' => 201, 'message' => $message ]);
                    }
                        
                }
                elseif($cart->option_id != ""){
                    $option = ProductOption::findOrFail($cart->option_id);
                    $quantity_option = ProductOption::findOrFail($cart->option_id);
                    if ($request->type == 'increase'){
                        if($option->limited_quantity ==1 && $option->available_quantity < $cart->quantity + 1){
                            $message = __('api.no_quantity_available');
                            return response()->json(['status' => false, 'code' => 201, 'message' => $message]);
                        }
                        $newValue = $cart->quantity + 1;
                        $cart->update(['quantity'=>$newValue]);
                        $message = __('website.ok');
                        return response()->json(['status' => true, 'code' => 200, 'message' => $message ,'items'=>$cart]);
                    }
                    else if ($request->type == 'decrease' && $cart->quantity > 1) {
                     
                        $newValue = $cart->quantity - 1;
                        if($cart->browsing_type == 2 && $cart->available == 0 && $newValue <= $quantity_option->available_quantity){
                            $cart->update(['quantity'=>$newValue, 'available' => 1]);
                            $message = __('api.product_in_available_item');
                            return response()->json(['status' => true, 'code' => 208, 'message' => $message ,'items'=>$cart]);
                        }
                        $cart->update(['quantity'=>$newValue]);
                        // if($cart->browsing_type == 1){
                            $message = __('website.ok');
                            return response()->json(['status' => true, 'code' => 200, 'message' => $message ,'items'=>$cart]);
                            
                        // }
                    }
                    else {
                        $message = __('api.not_found');
                          return response()->json(['status' => false, 'code' => 201, 'message' => $message ]);
                    }
                }
            }
            else {
                $message = __('api.not_found');
               return response()->json(['status' => false, 'code' => 201, 'message' => $message ]);
            }
        }
        $message = __('website.whoops');
        return response()->json(['status' => false,  'message' => $message ]);  

    }
	
	
	
	
   public function checkOut(Request $request){
	  //browsing_type = 1 stores , 2 = products
        if ($request->session()->get('sessionUser') !== null ) {
     		$store= User::find($request->store_id); 
			$gift_setting = $store->gift_setting;
			//$coupon = $request->coupon_code;
			//return $coupon;
		
		   if(auth()->check()){
                $validator = Validator::make($request->all(), [
                    // 'delivery_address' =>  'required_if:delivery_method,==,delivery',
                    'payment_method' => 'required|in:cash,online,wallet',
                    //'delivery_company_id' => 'required_if:browsing_type,==,1|required_if:delivery_method,==,delivery',
                    'browsing_type' => 'required',
					'store_id' => 'required_if:browsing_type,==,1',
					//'delivery_method' => 'required_if:browsing_type,==,1|in:delivery',
                    'mobile' =>  'required|regex:/^([0-9\s\-\+\(\)]*)$/|digits_between:8,13',
                    'email' => 'required',
                    'name' => 'required',
					'gift_contact_name' => [Rule::requiredIf(fn() => $request->delivery_method == 'gift' && $request->address_id == 0 )],
					'gift_contact_mobile' => [
						Rule::requiredIf(fn() => $request->delivery_method == 'gift' && $request->address_id == 0), 
						Rule::when($request->delivery_method == 'gift' && $request->address_id == 0, 'digits_between:8,13')
					],
					'is_wrap' => 'integer|in:1,0',
					'is_card' => 'integer|in:1,0',
					'is_gift_box' => 'integer|in:1,0',
					'card_note' => 'nullable|string',
					'gift_note' => 'nullable|string',
					
					'coupon_code' => 'nullable|string',
                ]);
				
				// oryxcode edit 19/11/2023 
                  if ($store->is_pickup == 1 && $request->delivery_method == 'pickup') {
					   $validator = Validator::make($request->all(), [
						   
                    'delivery_method' => 'required_if:browsing_type,==,1|in:pickup',
					 ]); 
				  }
                  if($request->delivery_method == 'delivery' && $request->browsing_type == 1){
                    $validator = Validator::make($request->all(), [
                    'address_id' => 'required_if:delivery_method,==,delivery',
                  
                    'delivery_company_id' => Rule::requiredIf(function () use ($request) {return $request->browsing_type ==1 && $request->delivery_method=='delivery';}),                    

                ]);  
                }
			 } else {
				$validator = Validator::make($request->all(), [
                    'payment_method' => 'required|in:cash,online,wallet',
                    'delivery_method' => 'required_if:browsing_type,==,1|in:delivery,pickup,gift',
                    'browsing_type' => 'required',
                    'store_id' => 'required_if:browsing_type,==,1',
                    'mobile' =>  'required|regex:/^([0-9\s\-\+\(\)]*)$/|digits_between:8,13',
                    'email' => 'required',
                    'name' => 'required',
					
                ]); 
			   if($request->delivery_method == 'delivery' && $request->browsing_type == 1){
				     $validator = Validator::make($request->all(), [
                    'city_id' => 'required_if:delivery_method,==,delivery',
                    // 'lat' => 'required',
                    // 'lng' => 'required',
                    'street' => 'required_if:delivery_method,==,delivery',
                    'zone' => 'required_if:delivery_method,==,delivery',
                    'bulding_no' => 'required_if:delivery_method,==,delivery',
                    // 'delivery_address' =>  'required_if:delivery_method,==,delivery',
                    'delivery_company_id' => 'required_if:browsing_type,==,1|required_if:delivery_method,==,delivery',
                   //'address_id' => 'required_if:delivery_method,==,delivery',
                
                ]); 
				 }
			     if($request->delivery_method == 'gift' && $request->browsing_type == 1){
					  $validator = Validator::make($request->all(), [ 
					 'is_wrap' => 'integer|in:1,0',
					'is_gift_box' => 'integer|in:1,0',
					'is_card' => 'integer|in:1,0',
					'card_note' => 'nullable|string',
					'gift_note' => 'nullable|string',
					'gift_contact_name' => 'required_if:delivery_method,==,gift',
					'gift_contact_mobile' => 'required|regex:/^([0-9\s\-\+\(\)]*)$/|digits_between:8,13',
					 ]); 
				 }
            }
		
			if($request->delivery_type == 2){
                    $validator = Validator::make($request->all(), [
                    'delivery_date' => 'required',
					'delivery_time' => 'required_if:delivery_method,==,delivery',
                ]);  
             }
			  
            if ($validator->fails()) {
                return response()->json(['status' => false, 'code' => 201,'message' => implode("\n", $validator->messages()->all())]);
            }
             if($request->delivery_method == 'delivery' && $request->browsing_type == 1 && ($request->lat == '' || $request->lat == 'lng') && !(Auth::check())){
                   return response()->json(['status' => false, 'code' => 201,'message' => __('website.addressInMapRequired')]);
                }
			//check payment method for gift delivery
			if($request->delivery_method == 'gift' && !in_array($request->payment_method, ['online', 'wallet'])){
                   return response()->json(['status' => false, 'code' => 201,'message' => __('website.WrongPaymentMethod')]);
             }
			//check if store gift option is still active
			if($request->delivery_method == 'gift' && !$gift_setting->active){
                   return response()->json(['status' => false, 'code' => 201,'message' => __('website.StoreGiftOptionClose')]);
             }
			//check if store gift wrap option is still active
			if(!empty($request->is_wrap) && !$gift_setting->is_wrap){
                   return response()->json(['status' => false, 'code' => 201,'message' => __('website.StoreGiftWrapClose')]);
             }
			//check if store gift wrap option is still active
			if(!empty($request->is_gift_box) && !$gift_setting->is_gift_box){
                   return response()->json(['status' => false, 'code' => 201,'message' => __('website.StoreGiftBoxClose')]);
             }
            $settings = Setting::query()->first();
			//$val = $request->has('address_id');
	      // return $val;
			//
			//return $request->address_id;
            if ( $request->has('address_id') >0 &&  $request->address_id != '' && $request->address_id > 0 && $request->delivery_method != "pickup" ){ 	
			
                $address = Address::findOrFail($request->address_id);
                $cityTo = $address->city_id;
                $latitude = $address->lat;
                $longitude = $address->lng;
            } else {
			    $cityTo = $request->city_id;
                $latitude = 0;
                $longitude = 0;
                $latitude = $request->lat;
                $longitude = $request->lng;
            }

            ///****************************Cart**********************************/////
            //browsing_type = 1 stores , 2 = products, 3 = restaurant
            $delivery_company_id = "";
            if ($request->has('browsing_type') &&  $request->browsing_type == 1) {
                    $store = User::findOrFail($request->store_id);
                    if($store->status_now == 0){
                        $message = __('api.closed');
                    return response()->json(['status' => false, 'code' => 201,'message' => $message]);
                    }
                    if($store->status == 'not_active'){
                        $message = __('api.storeNotActiveNow');
                    return response()->json(['status' => false, 'code' => 201,'message' => $message]);
                    }
                if(auth()->check()){
                         $carts = Cart::where('store_id', $request->store_id)->where('browsing_type', 1)->where(function ($q) use ($request) {
                        $q->where('fcm_token', $request->session()->get('sessionUser') )->orWhere('user_id', auth()->id());
                    })->with('product', 'store', 'additions')->get();

                }else{
                       $carts = Cart::where('store_id', $request->store_id)->where('browsing_type', 1)->where(function ($q) use ($request) {
                        $q->where('fcm_token', $request->session()->get('sessionUser'))->where('user_id' , null);
                    })->with('product', 'store', 'additions')->get();

                }
            
                if ($carts->count() > 0) {
                    $sub_total = 0;
					$gift_cost = 0;
					/** Coupon **/
					$couponCode = $request->coupon_code;
				
					$validity = '';
					$couponPercent = 0;
					$couponAmount = 0;
					$free_delivery = 0;
					$affected_stores= [];
					$affected_delivery_companies= [];
					$store_coupon_discount = 0;
					$discount_delivery = 0;
				if (!empty($couponCode)){
					$coupon = Coupon::where('coupon_number', $couponCode)->first();
					$dateNow = Carbon::now();
				    
				
					if(!empty($coupon)){
					   if($coupon->users == 'all' || ($coupon->users == 'old' && auth()->user()->created_at <= $coupon->affected_users ) || ($coupon->users == 'new' && auth()->user()->created_at >= $coupon->affected_users ) || ($coupon->users == 'selected' && in_array(auth()->user()->id, json_decode($coupon->affected_users))) ){
							if($coupon->limit_usage <= 0){// limit usage
								$validity= 'exceeded';
							}elseif ($coupon->expiry_date < $dateNow){// check expiry date
								$validity = 'expired'; 
							}else{ //valid
							    $validity = 'valid';
								$free_delivery = $coupon->free_delivery;
								$affected_stores = json_decode($coupon->affected_stores);
								$affected_delivery_companies = json_decode($coupon->delivery_companies);
								$couponPercent = $coupon->percent_from_basit + $coupon->percent_from_store;
								$couponAmount = $coupon->amount_from_basit + $coupon->amount_from_store;
							}
						}
					}
				}
				
					/**end Coupon**/
					
                    foreach ($carts as $item) {
                        if ($item->option_id == "") {
                            if(auth('web')->check() && $item->product->user_id == auth('web')->id()){
                                  $message = __('api.cantAddFromYourProduct');
                                return response()->json(['status' => false, 'code' => 201, 'message' => $message]);}
                                
                            if($item->product->limited_quantity == 1){
                                  if($item->product->available_quantity < $item->quantity){
                                  $message = __('api.no_quantity_available_enough'). " ". $item->product->name ." ". __('api.quantity_available'). $item->product->available_quantity;
                                return response()->json(['status' => false, 'code' => 201, 'message' => $message]);}
                            }
                           
                            $price = ($item->product->price_after_offer) ? $item->product->price_after_offer : $item->product->price;
                            $sub_total += $price * $item->quantity;
							$gift_cost += $request->delivery_method == 'gift' && !empty($request->is_wrap) ? $gift_setting->wrap_price * $item->quantity : 0;
	 
                        } elseif ($item->option_id != "") {
                            if(auth('web')->check() && $item->product->user_id == auth('web')->id()){
                                  $message = __('api.cantAddFromYourProduct');
                                return response()->json(['status' => false, 'code' => 201, 'message' => $message]);}
                                
                            $option = ProductOption::findOrFail($item->option_id);
                            if($option->limited_quantity == 1 ){
                                if($option->available_quantity < $item->quantity){
                                 $message = __('api.no_quantity_available_enough'). " ". $item->product->name . ('('.$option->name . ')') ." ". __('api.quantity_available'). $option->available_quantity;
                                return response()->json(['status' => false, 'code' => 201, 'message' => $message]);
                             }
                            }
                          
                            $price = ($option->offer_price) ? $option->offer_price : $option->price;
							 $sub_total += $price * $item->quantity;
							$gift_cost += $request->delivery_method == 'gift' && !empty($request->is_wrap) ? $gift_setting->wrap_price * $item->quantity : 0;
							
                        }
						
                        if ($item->additions != "") {
                            foreach ($item->additions as $addition) {

                               $addi = ProductAddition::where('id',$addition->addition_id)->first();
                               if($addi){
                                    $price_addition = ($addition->addition->offer_price) ? $addition->addition->offer_price : $addition->addition->price;
                                      if($addition->addition->free == 1){
                                               $sub_total += ($addition->quantity - 1) * $price_addition;
										  	   $gift_cost += $request->delivery_method == 'gift' && !empty($request->is_wrap) ? $gift_setting->wrap_price * ($addition->quantity - 1) : 0;
                                          }else{
                                               $sub_total += $addition->quantity * $price_addition;
										  	   $gift_cost += $request->delivery_method == 'gift' && !empty($request->is_wrap) ? $gift_setting->wrap_price * $addition->quantity : 0;
                                          }
                             
                               }else{
                               $message = __('api.addition_not_found');
                              return response()->json(['status' => false, 'code' => 201, 'message' => $message]);
                               }
                            }
                        }

                    }
                } else {
                    $message = __('api.cartEmpty');
                    return response()->json(['status' => false, 'code' => 201, 'message' => $message]);
                }
			 }
            elseif ($request->has('browsing_type') &&  $request->browsing_type == 2) {
                if(auth()->check()){
                       $carts = Cart::where('browsing_type', 2)->where('available', 1)->where(function ($q) use ($request) {
                        $q->where('fcm_token', $request->session()->get('sessionUser'))->orWhere('user_id', auth()->id());
                    })->with('product')->get();  
                }else{
                     $carts = Cart::where('browsing_type', 2)->where('available', 1)->where(function ($q) use($request) {
                        $q->where('fcm_token', $request->session()->get('sessionUser'))->where('user_id' , null);
                    })->with('product')->get(); 
                }
               
                if (isset($carts) && $carts->count() > 0) {
                    $sub_total = 0;
                    foreach ($carts as $item) {
                        if ($item->option_id == "") {
                            $price = ($item->product->price_after_offer) ? $item->product->price_after_offer : $item->product->price;
                            $sub_total += $price * $item->quantity;

                        } elseif ($item->option_id != "") {
                            $option = ProductOption::findOrFail($item->option_id);
                            $price = ($option->offer_price) ? $option->offer_price : $option->price;
                            $sub_total += $price * $item->quantity;

                        }
                        if ($item->additions != "") {
                            foreach ($item->additions as $addition) {
                                $price_addition = ($addition->addition->offer_price) ? $addition->addition->offer_price : $addition->addition->price;
                                  if($addition->addition->free == 1){
                                       $sub_total += ($addition->quantity - 1) * $price_addition;
                                  }else{
                                       $sub_total += $addition->quantity * $price_addition;
                                  }
                            }
                        }
                    }
                } else {
                    $message = __('api.cartEmpty');
                    return response()->json(['status' => false, 'code' => 201, 'message' => $message]);
                }
            }
            else {
                $message = __('api.whoops');
                return response()->json(['status' => false, 'code' => 201, 'message' => $message]);
            }
			
			$gift_cost += $request->delivery_method == 'gift' && !empty($request->is_gift_box) ? $gift_setting->gift_box_price : 0;
			$sub_total += $gift_cost;
			 
            ////*************************end cart********************************/////
			
			
			
            ////*********************Delivary method***********************///////
            //delivery_method = 1 pickup , 2 = delivery
            if ($request->has('delivery_method') && in_array($request->delivery_method, ['delivery', 'gift']) && $request->browsing_type == 1) {
              
				$store = User::findOrFail($request->store_id);
                $deliveryCost = 0;
                $min_order = 0;
                $duration = 0;
                if ($request->delivery_company_id == 0) {	
                    $delivery_company_id = 0;
                    if ($store->has_team == 1) {
                        if ($store->delivery_cost_type == 1) {
                            if ($store->city_id == $cityTo) {
                                $deliveryCost = $store->same_delivery_cost;
                                $min_order = $store->same_min_order;
                                $duration = $store->duration_same;
                            } else {
                             $check = NearestCity::where(function($q) use($cityTo, $store){
                                   $q->where('main_city' , $store->city_id)->where('city_id', $cityTo)->orWhere('main_city' , $cityTo)->where( 'city_id' , $store->city_id);
                               })->first();                                
                               if ($check) {
                                    $deliveryCost = $store->near_delivery_cost;
                                    $min_order = $store->near_min_order;
                                    $duration = $store->duration_near;
                                } else {
                                    $deliveryCost = $store->far_delivery_cost;
                                    $min_order = $store->far_min_order;
                                    $duration = $store->duration_far;
                                }
                            }
                        } else {
                            $delivery = DeliveryCost::where('store_id', $store->id)
                                ->where(function ($q) use ($store, $cityTo) {
                                    $q->where('cityfrom' , $store->city_id)->where( 'cityto' , $cityTo)
                                        ->orWhere('cityfrom', $cityTo)->where( 'cityto' , $store->city_id);
                                })->first();
                            $deliveryCost = $delivery->cost;
                            $min_order = $delivery->min_cost;
                            $duration = $delivery->duration;
                        }
                        
                        if ($min_order > $sub_total) {
                            $message = __('api.store_not_match_with_minimum_order') . ' ' .$store->name .' ( '. $min_order .' ) ' . __('api.Qatari Ryal');
                            return response()->json(['status' => false, 'code' => 201, 'message' => $message]);
                        }
                    }
                }else {
					
					 $delivery_company = DeliveryCompany::findOrFail($request->delivery_company_id);
                    $delivery_company_id = $delivery_company->id;
                    if ($delivery_company->delivery_cost_type == 1) {
					    if ($store->city_id == $cityTo) {
                            $deliveryCost = $delivery_company->same_delivery_cost;
                            $min_order = $delivery_company->same_min_order;
                            $duration = $delivery_company->same_duration;
                        } else {
                            $check = NearestCity::where(function($q) use($cityTo, $store){
                               $q->where('main_city' , $store->city_id)->where('city_id', $cityTo)->orWhere('main_city' , $cityTo)->where( 'city_id' , $store->city_id);
                           })->first();
                            if ($check) {
                                $delivery_company;
                                $deliveryCost = $delivery_company->near_delivery_cost;
                                $min_order = $delivery_company->near_min_order;
                                $duration = $delivery_company->near_duration;
                            } else {
                                $deliveryCost = $delivery_company->far_delivery_cost;
                                $min_order = $delivery_company->far_min_order;
                                $duration = $delivery_company->near_duration;
                            }
                        }

                    } else {
                        $delivery = DeliveryCost::where('delivery_company_id', $delivery_company->id)
                            ->where(function ($q) use ($store, $cityTo) {
                                $q->where('cityfrom' , $store->city_id)->where( 'cityto' , $cityTo)
                                    ->orWhere('cityfrom' , $cityTo)->where('cityto' , $store->city_id);
                            })->first();
                        $deliveryCost = $delivery->cost;
                        $min_order = $delivery->min_cost;
                        $duration = $delivery->duration;
                    }
                   
                    if ($min_order > $sub_total) {
                        $message = __('api.store_not_match_with_minimum_order') . ' ' .$delivery_company->name .' ( '. $min_order .' ) ' . __('api.Qatari Ryal');
                        return response()->json(['status' => false, 'code' => 201, 'message' => $message]);
                    }
                }
			
				/**coupon**/
				
	  if ($free_delivery == 1 && !empty($affected_delivery_companies) && in_array($request->delivery_company_id, $affected_delivery_companies)){
		  $discount_delivery = $deliveryCost;
		  $deliveryCost = 0;
		}
				/****/
				
            }
            elseif ($request->browsing_type == 2) {
                $deliveryCost = $settings->delivery_charge;
                $delivery_company_id = -2;
                $duration = 0;
				/**coupon**/
				if ($free_delivery == 1){
				 $discount_delivery = $deliveryCost;
				 $deliveryCost = 0;
				}
				/****/
            }
            elseif ($request->has('delivery_method') && $request->delivery_method == "pickup") {
                $deliveryCost = 0;
				
            }
            ////*******************end Delivary method*********************///////
            ////*******************create order****************************/////
            $vat_percent = $settings->value_added_tax;
              if ($request->has('browsing_type') && $request->browsing_type == 1) {
				     $app_percent = $store->app_percent;
                      if($app_percent < 0){
                           $app_percent = $settings->app_percent;
                      }              
              }else{
                   $app_percent = $settings->app_percent;
              }

			if (!empty($affected_stores) && in_array($request->store_id, $affected_stores)){
			$store_coupon_discount = ($sub_total * $coupon->percent_from_store)/100 + $coupon->amount_from_store;
			 }
			
            $app_total = ($sub_total * $app_percent) / 100;
            $vat = ($sub_total * $vat_percent) / 100;
            $store_total = $sub_total - $app_total - $store_coupon_discount; /**coupon**/
            $delivery = $deliveryCost;
            $total = $sub_total + $vat + $delivery;
			/** Coupon **/
			 if ($validity == 'valid'){
			 $discountAmount = ($total * $couponPercent)/100 + $couponAmount;
		     $total = $total - $discountAmount;
			 }
			/****/
		
            if ($request->payment_method == "wallet"){
                $userBalance = User::findOrFail(auth('web')->id());
                $rialPoint = 0;
                if($userBalance->num_points > 0){
                     $changePointValue = $settings->riyals_for_points;
                    $rialPoint =  $userBalance->num_points / $changePointValue;
                    }   
                $balance =$userBalance->balance + $rialPoint;
                if($balance != ''  && $balance < $total){
                    $message = __('api.balance_not_enough');
                    return response()->json(['status' => false, 'code' => 201, 'message' => $message]);
                }
            }
				
			/** start settlement **/
		$delivery_method = $request->delivery_method;
		$payment_method = $request->payment_method;
		$store_settings= DB::table('store_settings')
             ->where('store_id', $request->store_id)
             ->first();
			
		$generalSettings = DB::table('general_settings')
              ->first(); 
			
		 if ($delivery_method == 'delivery' || $delivery_method == 'gift'){ 
			 if($payment_method == 'cash'){  
				  $payment_percentage = 0;
				  $payment_commission = 0;
			   if($request->delivery_company_id == 1){ 
                    $platform_percentage = $store_settings->basit_delivery;
                }elseif ($request->delivery_company_id == 0){
                    $platform_percentage = $store_settings->store_delivery;
                }else{
                    $platform_percentage = $store_settings->delivery_provider;
                } 
				$platform_commission = ($sub_total *  $platform_percentage)/100;
				 
			 }elseif ($payment_method == 'online' || $payment_method == 'wallet' ){  
				 if ($total < 120 ){  
					 $payment_percentage = 0;
					 $payment_commission = 3;
				     if($request->delivery_company_id == 1){
                        $platform_percentage = $store_settings->basit_delivery;
                     }elseif ($request->delivery_company_id == 0){
                        $platform_percentage = $store_settings->store_delivery;
                     }else{
                        $platform_percentage = $store_settings->delivery_provider;
                     } 
				     $platform_commission = ($sub_total *  $platform_percentage)/100;
				 }elseif ($total >= 120 ){ 
					 $payment_percentage = $generalSettings->online_payment_fee;					 
					 $payment_commission = ($total * $payment_percentage)/100;
					  if($request->delivery_company_id == 1){
                        $platform_percentage = $store_settings->basit_delivery;
                     }elseif ($request->delivery_company_id == 0){
                        $platform_percentage = $store_settings->store_delivery;
                     }else{
                        $platform_percentage = $store_settings->delivery_provider;
                     } 
				     $platform_commission = ($sub_total *  $platform_percentage)/100;
				 }
			 }
		 }elseif ($delivery_method == 'pickup'){ 
			
			 $platform_percentage = $store_settings->pickup;
			 $platform_commission = ($sub_total *  $platform_percentage)/100;
			 if ($payment_method == 'cash'){ 
				  $payment_percentage = 0;
				  $payment_commission = 0;
			 }elseif($payment_method == 'online' || $payment_method == 'wallet' ){  
				 if ($total < 120 ){ 
					 $payment_percentage = 0;
					 $payment_commission = 3;
				 }elseif ($total >= 120 ){ 
					 $payment_percentage = $generalSettings->online_payment_fee;
					 $payment_commission = ($total * $payment_percentage)/100;
				 }			 
			 }	 
		 }
		
		
			$this_order_settelement_amount = $sub_total- $store_coupon_discount - ($payment_commission + $platform_commission); /**coupon**/
	
		/** end settlement **/
			
			$getDeliveryDate = [
				1 => Carbon::now()->addDay(1)->toDateString(),
				2 => Carbon::now()->addDay(2)->toDateString(),
				3 => Carbon::now()->addDay(3)->toDateString(),
			];
				
            $order = new Order();
			
            if (auth()->user()) {
                $order->user_id = auth()->user()->id;
            }
			//$order->delivery_date = $request->delivery_type != 1 ? $getDeliveryDate[$request->delivery_date] : null;			
			//$order->delivery_time = $request->delivery_type == 2  && $request->delivery_method == 'delivery' ? $request->delivery_time : null;
         
			$order->store_id = (isset($store))? $store->id : 0;
            $order->latitude = $latitude;
            $order->longitude = $longitude;
            $order->city_id = $cityTo;
            $order->name = $request->name;
            $order->mobile = $request->mobile;
            $order->email = $request->email;
            $order->street = $request->street;
            $order->zone = $request->zone;
            $order->bulding_no = $request->bulding_no;
            $order->delivery_method = $request->delivery_method;
            $order->delivery_company_id = $delivery_company_id;
            $order->delivery_address = $request->delivery_address;
            $order->delivery_cost = $deliveryCost;
            $order->address_id = $request->address_id;
            $order->browsing_type =$request->browsing_type;
            $order->total_price = $total;
            $order->sub_total = $sub_total;
            $order->vat_percent = $vat_percent;
            $order->vat = $vat;
            // $order->store_total = $store_total;
            $order->lang = getLocal();
            $order->is_gift = $request->delivery_method == 'gift' ? 1 : 0;
			$order->gift_cost = $gift_cost;
            // $order->app_percent = $app_percent;
            // $order->app_total = $app_total;
            $order->payment_method = $request->payment_method;
            $order->paymentStatus = 0;
            $order->fcm_token = $request->session()->get('sessionUser');
            $order->code_invoice = (string) Str::uuid();
            $order->order_number = (string)substr(str_shuffle(str_repeat("ABCDEFGHJKMNPQRSTUVWXYZ", 5)), 0, 3) . random_int ( 100000,999999);
             
            ///// - edited by oryxcode 13092023
            if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip_addr = $_SERVER['HTTP_CLIENT_IP'];
            } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip_addr = $_SERVER['HTTP_X_FORWARDED_FOR'];
            } else {
            $ip_addr = $_SERVER['REMOTE_ADDR'];
            }
            $order->ip_addr = $ip_addr;
            ///// - end edited by oryxcode 13092023
            
             //add settelement details with order oryxcode 29/11/23
			$order->payment_percent = $payment_percentage;
			$order->payment_commission = $payment_commission;
			$order->platform_percent = $platform_percentage;
			$order->platform_commission = $platform_commission;
			$order->order_settlement_amount = $this_order_settelement_amount;
		
		   /** coupon **/
           /*if($validity == 'valid' && $request->payment_method == "cash"){
           $order->discount_delivery = $discount_delivery;
	       $order->discount_checkout = $couponCode;
			// update coupon table
		   $usedBy= json_decode($coupon->used_by);
		   if(!empty($usedBy)){
		   array_push($usedBy, auth()->user()->id);
		   $coupon->used_by= json_encode($usedBy);   
		   }else{
			 $default_usedBy_arr = [];
	         array_push($default_usedBy_arr, auth()->user()->id);  
		     $coupon->used_by= json_encode($default_usedBy_arr); 
		   }
		   if($coupon->limit_usage != 'unlimited' && $coupon->limit_usage != 0){
		   $coupon->limit_usage -= 1;
		   }
		   $coupon->save();
		   }*/	
				
		   /****/
            $order->save();
			
            if ($order) {
			 if ($validity == 'valid'){	
             /*order coupon discount table start*/
				$orderCouponDiscount = new OrderCouponDiscount();
				$orderCouponDiscount->order_number = $order->order_number;
				$orderCouponDiscount->coupon_number = $couponCode;
				$orderCouponDiscount->percent_from_basit = $coupon->percent_from_basit;
				$orderCouponDiscount->amount_from_basit = $coupon->amount_from_basit;
				$orderCouponDiscount->percent_from_store = $coupon->percent_from_store;
				$orderCouponDiscount->amount_from_store = $coupon->amount_from_store;
				$orderCouponDiscount->free_delivery = $free_delivery;
				$orderCouponDiscount->coupon_percent = $couponPercent;
				$orderCouponDiscount->coupon_amount = $couponAmount;
				$orderCouponDiscount->save();
			 /*order coupon discount table end*/
			 }
				
             if($request->browsing_type == 1 && (isset($store))){
                 $sub_total =  $order->sub_total;
                  $app_percent = $store->app_percent;
				 if($app_percent < 0){
					 $app_percent = $settings->app_percent;
				 }    
                 $app_total = ($sub_total * $app_percent) / 100;
                 $newOrderStore = new OrderStore();
                 $newOrderStore->order_id = $order->id;
                 $newOrderStore->store_id = $store->id;
                 $newOrderStore->app_percent = $store->app_percent;
                 $newOrderStore->app_total = $app_total;
                 $newOrderStore->store_total = $sub_total - $app_total - $store_coupon_discount; /**coupon $store_coupon_discount 5/10/2025*/
                 $newOrderStore->total = $sub_total;
                 $newOrderStore->save();
				 
				 if($request->delivery_method == 'gift'){
				 	$order->gift()->updateOrCreate([
											'user_id' => $order->user_id,
											'number' => (string)substr(str_shuffle(str_repeat("ABCDEFGHJKMNPQRSTUVWXYZ", 5)), 0, 3) . random_int ( 100000,999999),                    
											'is_wrap' => $request->is_wrap ?? 0,
											'is_box' => $request->is_gift_box ?? 0,
											'is_card' => $request->is_card ?? 0,
											'card_note' => $request->card_note,
											'gift_note' => $request->gift_note,
											'name' => $request->gift_contact_name ? $request->gift_contact_name : $order->user->full_name,
											'mobile' => $request->gift_contact_mobile ? $request->gift_contact_mobile : $order->user->mobile,
											'city_id' => $request->city_id,
											'claimed' => 'direct',
											'active' => 'no',
											'ip' => $order->ip_addr,
										]);
				 
				 }
				 
             }
                $preparing_time = 0;
                foreach ($carts as $one) {
                    if($preparing_time <  (int)$one->product->preparing_time){
                        $preparing_time = (int)$one->product->preparing_time;
                    }
                   
                     //add in 26-06-2023 based on naser request
                      if ($one->option_id == "") {
                            $price = ($one->product->price_after_offer) ? $one->product->price_after_offer : $one->product->price;
                               
                        } elseif ($one->option_id != "") {
                            $option = ProductOption::findOrFail($one->option_id);
                            $price = ($option->offer_price) ? $option->offer_price : $option->price;
                               
                        }
				
                    if($request->payment_method == "wallet" || $request->payment_method == "cash" ){
                        if ($one->option_id == "") {
                            $price = ($one->product->price_after_offer) ? $one->product->price_after_offer : $one->product->price;
                                $product = Product::findOrFail($one->product_id);
                                $product->sales_number = $product->sales_number + 1;
                                $product->save();
                        } elseif ($one->option_id != "") {
                            $option = ProductOption::findOrFail($one->option_id);
                            $price = ($option->offer_price) ? $option->offer_price : $option->price;
                                $product = Product::findOrFail($one->product_id);
                                $product->sales_number = $product->sales_number + 1;
                                $product->save();
                        }
                    }
                    $data[] = [
                        'order_id' => $order->id,
                        'store_id' => $one->product->user_id,
                        'product_id' => $one->product_id,
                        'option_id' => $one->option_id,
                        'quantity' => $one->quantity,
                        'price' => $price,
						'price_before_offer'=> $one->product->price,
                        'total' => $price * $one->quantity,

                    ];
				
                    if($request->payment_method == "wallet" || $request->payment_method == "cash"){
                        if ($one->option_id != "") {
                            $q = ProductOption::findOrFail($one->option_id);
                            if ($q->limited_quantity == 1) {
                                $q->available_quantity = $q->available_quantity - $one->quantity;
								/**/
								 $newQuantity = new Quantity();
								 $newQuantity->product_id = $one->product_id;
                                 $newQuantity->option_id = $q->id;
								 $newQuantity->type = 2;
                                 $newQuantity->quantity = convertAr2En($one->quantity);
                                 $newQuantity->type_quantity = 2;
                                 $newQuantity->note = 'Order NB: '.$order->order_number;
                                 $newQuantity->save();
								/**/
                                $q->save();
                            }
                        }elseif ($one->option_id == "") {
                            $q = Product::findOrFail($one->product_id);
                            if ($q->limited_quantity == 1) {
                                $q->available_quantity = $q->available_quantity - $one->quantity;
									/**/
								 $newQuantity = new Quantity();
								 $newQuantity->product_id = $one->product_id;
								 $newQuantity->type = 1;
                                 $newQuantity->quantity = convertAr2En($one->quantity);
                                 $newQuantity->type_quantity = 2;
                                 $newQuantity->note = 'Order NB: '.$order->order_number;
                                 $newQuantity->save();
								/**/
                                $q->save();
                            }
                        }
                    }
                    if ($one->additions != "") {
                        foreach ($one->additions as $add) {
                          $priceAdd = ($add->addition->offer_price) ? $add->addition->offer_price : $add->addition->price;
                          if($add->addition->free == 1){
                              $quantity =$add->quantity - 1;
                              $free = 'one addition is free';
                          }else{
                              $quantity = $add->quantity;
                              $free = null;
                          }
                            $additions[] = [
                                'order_id' => $order->id,
                                'product_id' => $one->product_id,
                                'addition_id' => $add->addition_id,
                                'price' => $priceAdd,
                                'quantity' => $add->quantity,
                                'total' => $priceAdd * $quantity ,
                                'is_free'=>$free,
                            ];
                        }
                    }
                    
                      if($request->browsing_type == 2){
                         $oldStore = OrderStore::where('store_id' , $one->product->user_id)->where('order_id' , $order->id)->first();
                          if(!isset($oldStore)){
                             $newOrderStore = new OrderStore();
                             $newOrderStore->order_id = $order->id;
                             $newOrderStore->store_id = $one->product->user_id;
                             $newOrderStore->save();
                          }
                        
             }
                   

                }
                if ($request->has('delivery_method') && in_array($request->delivery_method, ["delivery", "gift"])){
                   (int)$preparing_time_new = 40 + $preparing_time + $duration;
				  //Add gift option preparing time
				   //$preparing_time_new += $wrap_time;
				   $preparing_time_new += $request->delivery_method == 'gift' && !empty($request->is_gift_box) ? $gift_setting->gift_box_time : 0; 
                   $order->estimated_arrival_time = Carbon::now()->addMinutes($preparing_time_new);
                   $order->save();
                }
				
                if($preparing_time == 0){
                    $order->update(['status' => 2]);
                }
                if (!empty($data)) {
                    ProductOrder::insert($data);
                }
                if (!empty($additions)) {
                    OrderAddition::insert($additions);
                }
                if($request->delivery_method == "gift"){
                    $order->update(['status' => 0]);
                }
                 if($request->browsing_type == 2){
                   $storeIds =  OrderStore::where('order_id' , $order->id)->pluck('store_id')->toArray();
                   if(isset($storeIds)){
                       foreach($storeIds as $oneId){
                      $totalStoreProducts = ProductOrder::where('store_id' , $oneId)->sum('total');
                      $updateStore = OrderStore::where('store_id',$oneId)->where('order_id' , $order->id)->first();
                      if(isset($updateStore)){
                           $app_percent = $updateStore->store->app_percent;
                          if($app_percent < 0){
                               $app_percent = $settings->app_percent;
                          }  
                          $app_total = ($app_percent * $totalStoreProducts) / 100;
                          $updateStore->app_percent = $app_percent;
                          $updateStore->app_total = $app_total;
                          $updateStore->store_total = $totalStoreProducts - $app_total - $store_coupon_discount; /**coupon $store_coupon_discount 5/10/2025*/                      
                          $updateStore->total = $totalStoreProducts;                      
                          $updateStore->save();     
                      }
                                      
                      }  
                   }
                 
                        
             }
				
				/*zero total amount scenario start*/
				if($total == 0){
					// test order notification 2-12-2023
					$statusNotif = $order->status;
					//notification for selected ids started
					$users_notif=[1, 230, 180, 184];
					foreach($users_notif as $usr){
					  $tokenx1 = Token::where(['user_id' => $usr, 'accept' => 1])->get();
					  $token_arx1 = $tokenx1->where('lang', 'ar')->pluck('fcm_token')->toArray();
					  $token_enx1 = $tokenx1->where('lang', 'en')->pluck('fcm_token')->toArray();
					   if (count($token_arx1) > 0) {
						sendNotificationToUsers($token_arx1, "1", 0, "طلب جديد", "طلب جديد");
						}
					   if (count($token_enx1) > 0) {
						 sendNotificationToUsers($token_enx1, "1", 0, "new order", "new order");
					   }
					}  
					//notification for selected ids end
					//becuase it is zero amount payment status set as paid
					$order->update(['paymentStatus' => 1 ]);	
					$order->save();
					//clear cart
					foreach($carts as $ca){
                       $ca->delete();
                    }
					/** coupon **/
					if($validity == 'valid'){
						 $order->discount_delivery = $discount_delivery;
						 $order->discount_checkout = $couponCode;
						 // update coupon table
						 $usedBy= json_decode($coupon->used_by);
						 if(!empty($usedBy)){
							 array_push($usedBy, auth()->user()->id);
							 $coupon->used_by= json_encode($usedBy);   
						 }else{
							 $default_usedBy_arr = [];
							 array_push($default_usedBy_arr, auth()->user()->id);  
							 $coupon->used_by= json_encode($default_usedBy_arr); 
						 } 
						 if($coupon->limit_usage != 'unlimited' && $coupon->limit_usage != 0){
						   	 $coupon->limit_usage -= 1;
						 }
						 $coupon->save();
					}	
                    $order->save();
					/**coupon end**/
					//send notification && email
                    dispatch(function () use ($order, $request , $preparing_time) {
                        $token = Token::where(['user_id'=> $order->store_id , 'accept'=>1])->get();
                        $token_ar = $token->where('lang' , 'ar')->pluck('fcm_token')->toArray();
                        $token_en = $token->where('lang' , 'en')->pluck('fcm_token')->toArray();
                        
                        $message_en =__('api.status0',[],"en" );
                        $message_ar = __('api.status0',[],"ar" );
                        $title_ar = __('api.newOrder', [], "ar");
                        $title_en = __('api.newOrder', [], "en");
						
                        if(count($token_ar) > 0){
                        	sendNotificationToUsers($token_ar , "1" , $order->id , $message_ar , $title_ar);
						}
                        if(count($token_en) > 0){
                         	sendNotificationToUsers($token_en , "1" , $order->id , $message_en , $title_en);
						}
                        $notification = new Notification();
                        $notification->user_id = $order->store_id;
                        $notification->fcm_token = $order->fcm_token;
                        $notification->order_id = $order->id;
                        $notification->translateOrNew('en')->message = $message_en;
                        $notification->translateOrNew('ar')->message = $message_ar;
                        $notification->translateOrNew('en')->title = $title_en;
                        $notification->translateOrNew('ar')->title = $title_ar;
                        $notification->save();
                        /////// Send Notification To Site
                        $storesIDs = OrderStore::where('order_id', $order->id)->pluck('store_id')->toArray();
                        foreach($storesIDs as $one){
                            updateFirebaseNotification('increment' , $one);
                        }
                        if($request->browsing_type == 2){
                            updateFirebaseDeliveryCompany('increment' , 1);
                        }elseif($preparing_time == 0 &&  $request->delivery_method == "delivery" && $order->delivery_company_id > 0){
                            updateFirebaseDeliveryCompany('increment' , $order->delivery_company_id);
                        }
                        $settings = Setting::query()->first();
                        $subject = __('cp.invoice');
                        $blade_data = array(
                            'subject' => $subject,
                            'settings' => $settings,
                            'order' => $order
                        );
                        $email_data = array(
                            'from' => env('MAIL_FROM_ADDRESS'),
                            'fromName' => env('MAIL_FROM_NAME'),
                            'to' => [$order->email]
						);
                        try {
                            Mail::send('emails.invoice', $blade_data, function ($message) use ($email_data, $subject) {
                                $message->to($email_data['to'])
                                    ->subject($subject)
                                    ->replyTo($email_data['from'], $email_data['fromName'])
                                    ->from($email_data['from'], $email_data['fromName']);
        
                            });
                        } catch (Exception $e) {
                            // do any thing  
                        }
                    })->afterResponse();
					/*end of send notification && email*/
					
					$message = __('website.ok');
                	return response()->json(['status' => true, 'code' => 200, 'message' => $message, 'url' => '']);
				}
				/*zero total amount scenario end*/
				
				
                if($request->payment_method == "wallet" || $request->payment_method == "cash"){
					
	 // test order notification 2-12-2023
	$statusNotif = $order->status;
	//notification for selected ids started
    $users_notif=[1, 230, 180, 184];
	foreach($users_notif as $usr){
      $tokenx1 = Token::where(['user_id' => $usr, 'accept' => 1])->get();
      $token_arx1 = $tokenx1->where('lang', 'ar')->pluck('fcm_token')->toArray();
      $token_enx1 = $tokenx1->where('lang', 'en')->pluck('fcm_token')->toArray();
       if (count($token_arx1) > 0) {
        sendNotificationToUsers($token_arx1, "1", 0, "طلب جديد", "طلب جديد");
        }
       if (count($token_enx1) > 0) {
         sendNotificationToUsers($token_enx1, "1", 0, "new order", "new order");
       }
	}  
    //notification for selected ids end
					
      // test order notification 2-12-2023
				
                    if ($request->payment_method == "wallet") {
                         $rialPoint = 0;
                        if($userBalance->num_points > 0){
                             $changePointValue = $settings->riyals_for_points;
                            $rialPoint =  $userBalance->num_points / $changePointValue;
                             if($rialPoint >= $total){
                             $numPointsDiscount =   $total *  $settings->riyals_for_points;
                                  $userBalance = User::findOrFail(auth()->id());
                                  $userBalance->num_points = $userBalance->num_points - $numPointsDiscount ;
                                  $userBalance->save();
                                    $newWallet = new Wallet();
                                    $newWallet->user_id = auth()->id();
                                    $newWallet->order_id = $order->id;
                                    $newWallet->type = 1;
                                    $newWallet->amount = $total;
                                    $newWallet->details = __('api.wallet_discount_points') . " " . $numPointsDiscount . " " .__('api.and_the_equivalent_in_riyals'). $total ;
                                    $newWallet->save();
                                    $order->update(['paymentStatus' => 1 ]);
										$order->save();
                            }elseif($rialPoint < $total){
                               
                                $newTotal  = $total - $rialPoint;
                                $newWallet = new Wallet();
                                $newWallet->user_id = auth()->id();
                                $newWallet->order_id = $order->id;
                                $newWallet->type = 1;
                                $newWallet->amount = $total;
                                $newWallet->details = __('api.wallet_discount_points') . " " . $userBalance->num_points . " " .__('api.and_the_equivalent_in_riyals'). $rialPoint . " " .__('api.wallet_discount') . " " . $newTotal;
                                $newWallet->save();
                                  $userBalance = User::findOrFail(auth()->id());
                                  $userBalance->balance = $userBalance->balance - $newTotal;
                                  $userBalance->num_points =0;
                                  $userBalance->save();
                                   $order->update(['paymentStatus' => 1 ]);
									$order->save();
                            }
                           }else{
                               
                                 $userBalance = User::findOrFail(auth()->id());
                                $balance = $userBalance->balance ;
                                 if($balance != null && $balance < $total){
                                        $message = __('api.balance_not_enough');
                                        return resFponse()->json(['status' => false, 'code' => 201, 'message' => $message]);
                                    }
                                $newWallet = new Wallet();
                                $newWallet->user_id = auth()->id();
                                $newWallet->order_id = $order->id;
                                $newWallet->type = 1;
                                $newWallet->amount = $total;
                                $newWallet->save();
                                  $userBalance->balance =  $balance - $total;
                                  $userBalance->save();
                                 $order->update(['paymentStatus' => 1 ]);	
								   $order->save();
                           }
                           
                       
                        foreach($carts as $ca){
                            $ca->delete();
                        }
						/** coupon **/
						   if($validity == 'valid'){
						   $order->discount_delivery = $discount_delivery;
						   $order->discount_checkout = $couponCode;
							// update coupon table
						   $usedBy= json_decode($coupon->used_by);
						   if(!empty($usedBy)){
						   array_push($usedBy, auth()->user()->id);
						   $coupon->used_by= json_encode($usedBy);   
						   }else{
							 $default_usedBy_arr = [];
							 array_push($default_usedBy_arr, auth()->user()->id);  
							 $coupon->used_by= json_encode($default_usedBy_arr); 
						   } 
						   if($coupon->limit_usage != 'unlimited' && $coupon->limit_usage != 0){
						   $coupon->limit_usage -= 1;
						   }
						   $coupon->save();
						   }	
                           $order->save();
						   /****/
                    }elseif($request->payment_method == "cash"){
                         foreach($carts as $ca){
                            $ca->delete();
                        }
						/** coupon **/
						   if($validity == 'valid'){
						   $order->discount_delivery = $discount_delivery;
						   $order->discount_checkout = $couponCode;
							// update coupon table
						   $usedBy= json_decode($coupon->used_by);
						   if(!empty($usedBy)){
						   array_push($usedBy, auth()->user()->id);
						   $coupon->used_by= json_encode($usedBy);   
						   }else{
							 $default_usedBy_arr = [];
							 array_push($default_usedBy_arr, auth()->user()->id);  
							 $coupon->used_by= json_encode($default_usedBy_arr); 
						   } 
						   if($coupon->limit_usage != 'unlimited' && $coupon->limit_usage != 0){
						   $coupon->limit_usage -= 1;
						   }
						   $coupon->save();
						   }	
                           $order->save();
						   /****/
                    } 
                       //send notification && email
                    dispatch(function () use ($order, $request , $preparing_time) {
                        $token = Token::where(['user_id'=> $order->store_id , 'accept'=>1])->get();
                        $token_ar = $token->where('lang' , 'ar')->pluck('fcm_token')->toArray();
                        $token_en = $token->where('lang' , 'en')->pluck('fcm_token')->toArray();
                        
                         $message_en =__('api.status0',[],"en" );
                         $message_ar = __('api.status0',[],"ar" );
                         $title_ar = __('api.newOrder', [], "ar");
                         $title_en = __('api.newOrder', [], "en");
						
                         if(count($token_ar) > 0){
                        sendNotificationToUsers($token_ar , "1" , $order->id , $message_ar , $title_ar);}
                          if(count($token_en) > 0){
                         sendNotificationToUsers($token_en , "1" , $order->id , $message_en , $title_en);}
                         $notification = new Notification();
                         $notification->user_id = $order->store_id;
                         $notification->fcm_token = $order->fcm_token;
                         $notification->order_id = $order->id;
                         $notification->translateOrNew('en')->message = $message_en;
                         $notification->translateOrNew('ar')->message = $message_ar;
                         $notification->translateOrNew('en')->title = $title_en;
                         $notification->translateOrNew('ar')->title = $title_ar;
                         $notification->save();
                        /////// Send Notification To Site
                          $storesIDs = OrderStore::where('order_id', $order->id)->pluck('store_id')->toArray();
                          foreach($storesIDs as $one){
                            updateFirebaseNotification('increment' , $one);
                            
                           }
                           if($request->browsing_type == 2){
                            updateFirebaseDeliveryCompany('increment' , 1);
                           }elseif($preparing_time == 0 &&  $request->delivery_method == "delivery" && $order->delivery_company_id > 0){
                                updateFirebaseDeliveryCompany('increment' , $order->delivery_company_id);
                           }
                        $settings = Setting::query()->first();
                        $subject = __('cp.invoice');
                        $blade_data = array(
                            'subject' => $subject,
                            'settings' => $settings,
                            'order' => $order
                        );
                        $email_data = array(
                            'from' => env('MAIL_FROM_ADDRESS'),
                            'fromName' => env('MAIL_FROM_NAME'),
                            'to' => [$order->email]);
                        try {
                            Mail::send('emails.invoice', $blade_data, function ($message) use ($email_data, $subject) {
                                $message->to($email_data['to'])
                                    ->subject($subject)
                                    ->replyTo($email_data['from'], $email_data['fromName'])
                                    ->from($email_data['from'], $email_data['fromName']);
        
                            });
                        } catch (Exception $e) {
                            // do any thing  
                        }
        
        
                    })->afterResponse();
                    // if( $request->browsing_type == 1){
                    //       $message = __('api.Done_Successfully');
                    // return response()->json(['status' => true, 'code' => 200, 'message' => $message , 'store_status'=>$store->status_now]);
                    // }else{
                    //       $message = __('api.Done_Successfully');
                    // return response()->json(['status' => true, 'code' => 200, 'message' => $message]);
                    // }
					
                    $message = __('website.ok');
                return response()->json(['status' => true, 'code' => 200, 'message' => $message, 'url' => '']);
                }
                elseif ($request->payment_method == "online") {
                    $post_data =['id'=>$order->id,'amount'=>$order->total_price,'name'=>$order->name,'mobile'=>$order->mobile,'email'=>$order->email,'fcm_token'=>$order->fcm_token,'wallet_id'=>0];
                    $payment = payment('web_order', $post_data);
					//return $payment;
                    $data = json_decode($payment, true);
                    $url = $data['result']['checkout_url'];
					
				//return $data;
                Cart::whereIn('id',$carts->pluck('id')->toArray())->update(['order_id'=>$order->id]); 
				/** coupon **/
						   if($validity == 'valid'){
						   $order->discount_delivery = $discount_delivery;
						   $order->discount_checkout = $couponCode;
							// update coupon table
						   $usedBy= json_decode($coupon->used_by);
						   if(!empty($usedBy)){
						   array_push($usedBy, auth()->user()->id);
						   $coupon->used_by= json_encode($usedBy);   
						   }else{
							 $default_usedBy_arr = [];
							 array_push($default_usedBy_arr, auth()->user()->id);  
							 $coupon->used_by= json_encode($default_usedBy_arr); 
						   } 
						   if($coupon->limit_usage != 'unlimited' && $coupon->limit_usage != 0){
							   $coupon->limit_usage -= 1;
						   }
						   $coupon->save();
						   }	
                           $order->save();
						   /****/		
                $message = __('website.ok');
                return response()->json(['status' => true, 'code' => 200, 'message' => $message, 'url' => $url]);
                }
               
            }
            else {
                $message = __('api.whoops');
                return response()->json(['status' => false, 'code' => 201, 'message' => $message]);
            }
        }else {
            $message = __('api.whoops');
            return response()->json(['status' => false, 'code' => 201, 'message' => $message]);
        }
    }
    
    public function checkStoresPaymentMinOrder(Request $request){
        if($request->session()->get('sessionUser') !==''){
            $validator = Validator::make($request->all(),[
                'address_id'=>'required_without:city_id',
                'city_id'=>'required_without:address_id',
                'delivery_method' => 'required',
            ]);
            if ($validator->fails()) {
              return ['status' => false,'notOkStores'=>[],  'message' => implode("\n", $validator->messages()->all()) ];
            }
            if($request->has('address_id')  && $request->address_id !=''){
                $address = Address::findOrFail($request->address_id);
                $cityTo = $address->city_id;
            }else{
                 $cityTo = $request->city_id;
            }
            $carts = Cart::with('product')->where('user_id' , auth('web')->id())->orWhere('fcm_token',$request->session()->get('sessionUser'))->get();
			
            // $delivery_method = explode(';',$request->delivery_method);
            $delivery_method = $request->delivery_method;
            $totalPriceAll = 0;
            $deliveryCost =0;
            $message = "";
            $errorList = array();
            foreach($delivery_method as $one){
                $totalPrice = 0;
                $cityFrom = 0;
                $d_m = explode(',',$one);
                if(!isset($d_m[0]) || !isset($d_m[1])){
                    continue;
                }
                else{
                    if($d_m[1] == '-2'){//pickup
                        $store = User::findOrFail($d_m[0]);
                        if($store->status_now ==0){
                            continue;
                        }
                        foreach ($carts->where('store_id',$d_m[0]) as $one) {
                           $price =  ($one->product->price_after_offer)? $one->product->price_after_offer:$one->product->price;
                            $totalPrice +=$price * $one->quantity;
                        }
                        $totalPriceAll += $totalPrice;
                        continue;
                    }
                    if($d_m[1] == '0'){//delivery by store
                        $store = User::findOrFail($d_m[0]);
                        if($store->status_now ==0){
                            continue;
                        }
                        $cityFrom = $store->city_id;
                        foreach ($carts->where('store_id',$d_m[0]) as $one){
                            $price =  ($one->product->price_after_offer)? $one->product->price_after_offer:$one->product->price;
                            $totalPrice +=$price * $one->quantity;
                        }
                        $totalPriceAll += $totalPrice;
                        if($store->delivery_cost_type == 1){
                            if($cityFrom == $cityTo && $totalPrice >= $store->same_min_order){
                                $deliveryCost += $store->same_delivery_cost;
                            }else{
                                $check = NearestCity::where(function($q){
                                    $q->where('main_city',$cityFrom)->where('city_id',$cityTo)
                                ->orWhere('main_city',$cityTo)->where('city_id',$cityFrom);
                                })->first();

                                if($check){
                                    if($totalPrice >= $store->near_min_order){
                                        $deliveryCost += $store->near_delivery_cost;
                                    }else{
                                        $errorList[] = $store->id;
                                        $message .= __('api.in_store')." ".$store->name." ".__('api.store_not_match_with_minimum_order')."\n";
                                        continue;
                                    }
                                }
                                else{
                                    if( $totalPrice >= $store->far_min_order){
                                        $deliveryCost += $store->far_delivery_cost;
                                    }else{
                                        $errorList[] = $store->id;
                                        $message .= __('api.in_store')." ".$store->name." ".__('api.store_not_match_with_minimum_order')."\n";
                                        continue;
                                    }
                                }

                            }
                        }else{
                            $deliveryCost += DeliveryCost::where('store_id', $store->id)
                            ->where(function ($q) use ($store, $cityTo) {
                                $q->where('cityfrom' , $store->city_id)->where('cityto' , $cityTo)
                                ->orWhere('cityfrom' , $cityTo)->where('cityto' , $store->city_id);
                            })->pluck('cost')->first();
                        }

                            // same_delivery_cost     near_delivery_cost      far_delivery_cost
                            //  same_min_order      near_min_order       far_min_order
                    }
                    if($d_m[1] > 0){//deliver by company
                        $store = User::findOrFail($d_m[0]);
                        if($store->status_now ==0){
                            continue;
                        }
                        $company = DeliveryCompany::findOrFail($d_m[1]);
                        $cityFrom = $store->city_id;
                        foreach ($carts->where('store_id',$d_m[0]) as $one) {
                            $price =  ($one->product->price_after_offer)? $one->product->price_after_offer:$one->product->price;
                            $totalPrice +=$price * $one->quantity;
                        }
                        if($company->delivery_cost_type == 1){
                            if($cityFrom == $cityTo && $totalPrice >= $company->same_min_order){
                                $deliveryCost += $company->same_delivery_cost;
                            }else{
                                $check = NearestCity::where(function($q){
                                    $q->where('main_city',$cityFrom)->where('city_id',$cityTo)
                                    ->orWhere('main_city',$cityTo)->where('city_id',$cityFrom);
                                })->first();

                                if($check){
                                    if($totalPrice >= $company->near_min_order){
                                        $deliveryCost += $company->near_delivery_cost;
                                    }else{
                                        $errorList[] = $store->id;
                                        $message .= __('api.in_store')." ".$store->name." ".__('api.store_not_match_with_minimum_order')."\n";
                                        continue;
                                    }
                                }
                                else{
                                    if( $totalPrice >= $company->far_min_order){
                                        $deliveryCost += $company->far_delivery_cost;
                                    }else{
                                        $errorList[] = $store->id;
                                        $message .= __('api.in_store')." ".$store->name." ".__('api.store_not_match_with_minimum_order')."\n";
                                        continue;
                                    }
                                }

                            }
                        }
                        else{
                            $deliveryCost += DeliveryCost::where('delivery_company_id', $company->id)
                            ->where(function ($q) use ($cityFrom, $cityTo) {
                                $q->where(['cityfrom' => $cityFrom, 'cityto' => $cityTo]);
                            })->pluck('cost')
                            ->first();
                        }
                        $totalPriceAll += $totalPrice;
                        // same_delivery_cost     near_delivery_cost      far_delivery_cost
                        //  same_min_order      near_min_order       far_min_order
                    }
                }
            }
            if(!empty($errorList)){
                return ['status' => false, 'notOkStores'=>$errorList,  'message' => $message];
            }
           // $totalPriceAll = $totalPrice+$deliveryCost;
            return ['status' => true,'deliveryCost'=>$deliveryCost,'sub_total'=>$totalPriceAll, 'total'=>$totalPriceAll+$deliveryCost];
        }
        $message = __('api.whoops');
        return ['status' => false,  'notOkStores'=>[], 'message' => $message ];
    }

    public function getDeliveryCompanyByStore(Request $request){
        if($request->session()->get('sessionUser') !==''){
            $valid = Validator::make($request->all(),[
                'address_id'=>'required_without:city_id',
                'city_id'=>'required_without:address_id',
                'store_id' => 'required',
				'is_wrap' => 'integer|in:1,0',
				'is_gift_box' => 'integer|in:1,0',
				'is_card' => 'integer|in:1,0',
            ]);
            if ($valid->fails()) {
              return Response()->json($valid->errors());
            }
            if($request->has('address_id')  && !empty($request->address_id)){
                $address = Address::findOrFail($request->address_id);
                $cityTo = $address->city_id;
            }else{
                 $cityTo = $request->city_id;
            }
			
			/*store location and customer location start*/
			/*
			$storeLat = $store->lat;
			$storeLat = $store->lat;*/
			/*store location and customer location end*/

            $carts = Cart::with('product')->where('store_id',$request->store_id)->where('user_id' , auth('web')->id())->orWhere('fcm_token',$request->session()->get('sessionUser'))->get();
$store = User::findOrFail($request->store_id);
            $delivery_companies = DeliveryCompany::where('status','active')
									->when($request->delivery_method == 'gift', fn($q) => $q->where('id', 1)) //If delivery method is gift then select only Basit store
									->orderBy('id','asc')->get();
            $list = array();
            $duration = 0;
            $deliveryCost=0;$min_order = 0;
            $estimated_arrival_time = '';
            $preparing_time = 0 ;
			
			//check if the delivery method is a gift then add wrap_time and gift_box_time
			if($request->delivery_method == 'gift'){
				$preparing_time = !empty($request->is_wrap) ? $preparing_time +  $store->gift_setting->wrap_time : $preparing_time;
				$preparing_time = !empty($request->is_gift_box) ? $preparing_time +  $store->gift_setting->gift_box_time : $preparing_time;
			}
            foreach ($carts as $item){
                  if($preparing_time <  (int)$item->product->preparing_time){
                    $preparing_time = (int)$item->product->preparing_time;
                }
            }
			
            if(!empty($delivery_companies)){
                if(isset($delivery_companies[0]) && $delivery_companies[0]->id  == 1){
                    if($delivery_companies[0]->delivery_cost_type == 1){//per area
                        if($store->city_id == $cityTo){
                            $deliveryCost = $delivery_companies[0]->same_delivery_cost;
                            $min_order = $delivery_companies[0]->same_min_order;
                           $duration = $delivery_companies[0]->same_duration;
                        }else{
                            // $check = NearestCity::where(['main_city'=>$store->city_id,'city_id'=>$cityTo])->orWhere(['main_city'=>$cityTo,'city_id'=>$store->city_id])->first();
                            $check = NearestCity::where(['main_city'=>$store->city_id,'city_id'=>$cityTo])->first();
                            if($check){
                                $deliveryCost = $delivery_companies[0]->near_delivery_cost;
                                $min_order = $delivery_companies[0]->near_min_order;
                                $duration = $delivery_companies[0]->near_duration;
                            }else{
                                $deliveryCost = $delivery_companies[0]->far_delivery_cost;
                                $min_order = $delivery_companies[0]->far_min_order;
                               $duration = $delivery_companies[0]->far_duration;
                            }
                        }
                    }
                    else{//per city
                        $deliveryOne = DeliveryCost::where('delivery_company_id', $delivery_companies[0]->id)
                        ->where(function ($q) use ($store, $cityTo) {
                            $q->where(['cityfrom' => $store->city_id, 'cityto' => $cityTo]);
                        })->first();
                        // $deliveryTwo = DeliveryCost::where('delivery_company_id', $delivery_companies[0]->id)
                        // ->where(function ($q) use ($store, $cityTo) {
                        //     $q->where(['cityfrom' => $cityTo, 'cityto' => $store->city_id]);
                        // })->first();
                        if(isset($deliveryOne) && $deliveryOne != null){
                          $delivery = $deliveryOne;
                        }
                        // elseif(isset($deliveryTwo) && $deliveryTwo != null){
                        //       $delivery = $deliveryTwo;
                        // }
                        if($delivery){
                            $deliveryCost = $delivery->cost;
                            $min_order = $delivery->min_cost;
                           $duration += $delivery->duration;
                        }
                    }
                    //if($deliveryCost !=0){
                         (int)$preparing_time_new = 40 + $preparing_time + $duration;
                        //6/25/2024$estimated_arrival_time = Carbon::now()->addMinutes($preparing_time_new)->diffForHumans(null, true, false, 2);
					    $estimated_arrival_time = Carbon::now()->addMinutes($preparing_time_new)->format('Y-m-d h:i a');
                        $list[] =['id'=>$delivery_companies[0]->id,'name' =>$delivery_companies[0]->name,'cost'=>$deliveryCost,'min_order'=>$min_order , 'estimated_arrival_time'=>$estimated_arrival_time, '$preparing_time' => $preparing_time_new];
                    //}

                }
            }
            if($store->has_team ==1){
                if($store->delivery_cost_type == 1){
                    if($store->city_id == $cityTo){
                        $deliveryCost = $store->same_delivery_cost;
                        $min_order = $store->same_min_order;
                        $duration = $store->same_duration;
                        
                    }else{
                        $check = NearestCity::where(['main_city'=>$store->city_id,'city_id'=>$cityTo])->first();
                        if($check){
                            $deliveryCost = $store->near_delivery_cost;
                            $min_order = $store->near_min_order;
                            $duration = $store->far_duration;
                        }else{
                            $deliveryCost = $store->far_delivery_cost;
                            $min_order = $store->far_min_order;
                            $duration = $store->far_duration;
                        }
                    }
                }
                else{
                     $delivery = DeliveryCost::where('store_id', $store->id)->where('cityfrom', $store->city_id)->where('cityto', $cityTo)->first();
                        if($delivery){
                        $deliveryCost = $delivery->cost;
                        $min_order = $delivery->min_cost;
                        $duration += $delivery->duration;
                    }
                }
                if($deliveryCost !=0){
                      (int)$preparing_time_new = 40 + $preparing_time + $duration;
                       // $estimated_arrival_time = Carbon::now()->addMinutes($preparing_time_new)->diffForHumans(null, true, false, 2);
					 $estimated_arrival_time = Carbon::now()->addMinutes($preparing_time_new)->format('Y-m-d h:i a');
                    $list[] =['id'=>0,'name' =>$store->name." (".__('api.deliveryStore').")",'cost'=>$deliveryCost,'min_order'=>$min_order,'estimated_arrival_time'=>$estimated_arrival_time, '$preparing_time' => $preparing_time_new];
                }

            }
            if(!empty($delivery_companies)){
                foreach($delivery_companies->where('id','>',1) as $comp){
                    $deliveryCost=0;$min_order = 0;
                    if($comp->delivery_cost_type == 1){
                        if($store->city_id == $cityTo){
                            $deliveryCost = $comp->same_delivery_cost;
                            $min_order = $comp->same_min_order;
                            $duration = $comp->same_duration;
                        }else{
                            $check = NearestCity::where(['main_city'=>$store->city_id,'city_id'=>$cityTo])->first();
                            if($check){
                                $deliveryCost = $comp->near_delivery_cost;
                                $min_order = $comp->near_min_order;
                                $duration = $comp->near_duration;
                            }else{
                                $deliveryCost = $comp->far_delivery_cost;
                                $min_order = $comp->far_min_order;
                                $duration = $comp->far_duration;
                            }
                        }
                    }
                    else{
                        $delivery = DeliveryCost::where('delivery_company_id', $comp->id)->where('cityfrom' , $store->city_id)->where( 'cityto' , $cityTo)->first();
                    
                        if($delivery){
                            $deliveryCost = $delivery->cost;
                            $min_order = $delivery->min_cost;
                            $duration += $delivery->duration;
                        }
                    }
                    if($deliveryCost !=0){
                         (int)$preparing_time_new = 40 + $preparing_time + $duration;
                        //$estimated_arrival_time = Carbon::now()->addMinutes($preparing_time_new)->diffForHumans(null, true, false, 2);
						$estimated_arrival_time = Carbon::now()->addMinutes($preparing_time_new)->format('Y-m-d h:i a');
                        $list[] =['id'=>$comp->id,'name' =>$comp->name,'cost'=>$deliveryCost,'min_order'=>$min_order ,'estimated_arrival_time'=>$estimated_arrival_time, '$preparing_time' => $preparing_time_new];
                    }

                }
            }
            if(!empty($list)){
                return ['status' => true,  'delivery_companies'=>$list];
            }
            $message = __('api.sorryNoDeliveryForThisStore');
            return ['status' => false,  'message' => $message ];
        }
        $message = __('api.whoops');
        return ['status' => false,  'message' => $message ];
    }

    public function deliveryCost(Request $request){
        $user = auth('web')->id();
        $cart = Cart::where('user_id',$user)->first();
        if($cart) {
            $productDetails = Product::findOrFail($cart->product_id);
            $cityFrom = $productDetails->store->city_id;
            $cityTo = $request->cityto;
            $costDelivery = DeliveryCost::where('delivery_company_id', $request->delivery_company_id)
                ->where(function ($q) use ($cityFrom, $cityTo) {
                    $q->where('cityfrom' , $cityFrom)->where('cityto' , $cityTo);
                })->pluck('cost')->first();
           
            $costDelivery = ($costDelivery)? $costDelivery:"0";
            return $costDelivery;
        }

        return 0;

    }

}
